/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.base.utils.Escaper;
import pl.edu.icm.unity.engine.api.authn.InvocationContext;
import pl.edu.icm.unity.engine.api.authn.LoginSession;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.identity.AbstractIdentityTypeProvider;
import pl.edu.icm.unity.stdext.identity.SessionIdentityModel;
import pl.edu.icm.unity.types.basic.Identity;
import pl.edu.icm.unity.types.basic.IdentityParam;

@Component
public class TransientIdentity
extends AbstractIdentityTypeProvider {
    public static final String ID = "transient";
    private ObjectMapper mapper = Constants.MAPPER;

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "TransientIdentity.description";
    }

    @Override
    public boolean isRemovable() {
        return false;
    }

    public void validate(String value) {
    }

    public String getComparableValue(String from, String realm, String target) {
        LoginSession ls;
        if (realm == null || target == null) {
            return null;
        }
        try {
            InvocationContext ctx = InvocationContext.getCurrent();
            ls = ctx.getLoginSession();
            if (ls == null) {
                return null;
            }
        }
        catch (InternalException e) {
            return null;
        }
        return this.getComparableValueInternal(from, realm, target, ls);
    }

    private String getComparableValueInternal(String from, String realm, String target, LoginSession ls) {
        return Escaper.encode((String[])new String[]{realm, target, ls.getId(), from});
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        return from.getValue();
    }

    public boolean isDynamic() {
        return true;
    }

    public Identity createNewIdentity(String realm, String target, long entityId) {
        if (realm == null || target == null) {
            throw new IllegalArgumentException("Identity can be created only when target is defined");
        }
        String value = UUID.randomUUID().toString();
        try {
            InvocationContext ctx = InvocationContext.getCurrent();
            LoginSession ls = ctx.getLoginSession();
            if (ls == null) {
                return null;
            }
            SessionIdentityModel model = new SessionIdentityModel(this.mapper, ls, value);
            ObjectNode contents = model.serialize();
            String comparableValue = this.getComparableValueInternal(value, realm, target, ls);
            Identity ret = new Identity(ID, value, entityId, comparableValue);
            ret.setMetadata((JsonNode)contents);
            ret.setTarget(target);
            ret.setRealm(realm);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("Identity can be created only when login session is defined", e);
        }
    }

    public boolean isExpired(Identity representation) {
        SessionIdentityModel model = new SessionIdentityModel(this.mapper, (ObjectNode)representation.getMetadata());
        SessionIdentityModel.PerSessionEntry info = model.getEntry();
        return info.isExpired();
    }

    public boolean isTargeted() {
        return true;
    }

    @Override
    public String toHumanFriendlyString(MessageSource msg, IdentityParam from) {
        return msg.getMessage("TransientIdentity.random", new Object[0]);
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("TransientIdentity.description", new Object[0]);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("TransientIdentity.name", new Object[0]);
    }
}

