/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.exceptions.IllegalIdentityValueException;
import pl.edu.icm.unity.stdext.identity.AbstractStaticIdentityTypeProvider;
import pl.edu.icm.unity.types.basic.IdentityParam;

@Component
public class UsernameIdentity
extends AbstractStaticIdentityTypeProvider {
    public static final String ID = "userName";

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "UsernameIdentity.description";
    }

    public void validate(String value) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("Username must be non empty");
        }
    }

    @Override
    public IdentityParam convertFromString(String stringRepresentation, String remoteIdp, String translationProfile) throws IllegalIdentityValueException {
        return super.convertFromString(stringRepresentation.trim(), remoteIdp, translationProfile);
    }

    public String getComparableValue(String from, String realm, String target) {
        return from;
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        return from.getValue();
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("UsernameIdentity.description", new Object[0]);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("UsernameIdentity.name", new Object[0]);
    }
}

