/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.validator.routines.DomainValidator;

public class GenerateAdditionalValidTLDsList {
    private static final String IANA_REGISTRY = "https://data.iana.org/TLD/tlds-alpha-by-domain.txt";

    public static void main(String[] args) throws Exception {
        List<String> allTlds = GenerateAdditionalValidTLDsList.readDomains();
        Set<String> known = GenerateAdditionalValidTLDsList.getKnown();
        List missing = allTlds.stream().map(String::toLowerCase).filter(s -> !known.contains(s)).sorted().collect(Collectors.toList());
        System.out.println(missing.stream().collect(Collectors.joining("\",\n\"", "{\"", "\"};")));
    }

    private static List<String> readDomains() throws IOException {
        URL url = new URL(IANA_REGISTRY);
        InputStream is = url.openStream();
        List ret = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.US_ASCII);
        ret.remove(0);
        return ret;
    }

    private static Set<String> getKnown() {
        HashSet<String> allKnown = new HashSet<String>();
        Collections.addAll(allKnown, DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO));
        Collections.addAll(allKnown, DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO));
        Collections.addAll(allKnown, DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO));
        return allKnown;
    }
}

