/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import java.util.UUID;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.stdext.identity.AbstractIdentityTypeProvider;
import pl.edu.icm.unity.types.basic.Identity;
import pl.edu.icm.unity.types.basic.IdentityParam;

@Component
public class PersistentIdentity
extends AbstractIdentityTypeProvider {
    public static final String ID = "persistent";

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "PersistentIdentity.description";
    }

    public void validate(String value) {
    }

    public String getComparableValue(String from, String realm, String target) {
        return from;
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        return from.getValue();
    }

    public boolean isDynamic() {
        return true;
    }

    public Identity createNewIdentity(String realm, String target, long entityId) {
        String value = UUID.randomUUID().toString();
        Identity ret = new Identity(ID, value, entityId, value);
        ret.setRealm(realm);
        ret.setTarget(null);
        return ret;
    }

    public boolean isTargeted() {
        return false;
    }

    public boolean isExpired(Identity representation) {
        return false;
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("PersistentIdentity.description", new Object[0]);
    }

    @Override
    public String toHumanFriendlyString(MessageSource msg, IdentityParam from) {
        return msg.getMessage("PersistentIdentity.anonymous", new Object[0]);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("PersistentIdentity.name", new Object[0]);
    }
}

