/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import pl.edu.icm.unity.engine.api.authn.LoginSession;

public class SessionIdentityModel {
    private ObjectMapper mapper;
    private PerSessionEntry entry;

    public SessionIdentityModel(ObjectMapper mapper, ObjectNode entryVal) {
        this.mapper = mapper;
        this.entry = new PerSessionEntry(entryVal.get("absoluteTTL").asLong(), entryVal.get("relativeTTL").asLong(), entryVal.get("lastUsage").asLong(), entryVal.get("idValue").asText());
    }

    public SessionIdentityModel(ObjectMapper mapper, LoginSession session, String identity) {
        this.mapper = mapper;
        this.entry = new PerSessionEntry(session.getExpires() == null ? -1L : session.getExpires().getTime(), session.getMaxInactivity() * 10L, System.currentTimeMillis(), identity);
        long msInHour = 3600000L;
        if (this.entry.relativeTTL < 24L * msInHour) {
            this.entry.relativeTTL = 24L * msInHour;
        }
    }

    public ObjectNode serialize() {
        ObjectNode eN = this.mapper.createObjectNode();
        eN.put("absoluteTTL", this.entry.absoluteTTL);
        eN.put("relativeTTL", this.entry.relativeTTL);
        eN.put("lastUsage", this.entry.lastUsage);
        eN.put("idValue", this.entry.idValue);
        return eN;
    }

    public PerSessionEntry getEntry() {
        return this.entry;
    }

    public static class PerSessionEntry {
        private long absoluteTTL;
        private long relativeTTL;
        private long lastUsage;
        private String idValue;

        public PerSessionEntry(long absoluteTTL, long relativeTTL, long lastUsage, String idValue) {
            this.absoluteTTL = absoluteTTL;
            this.relativeTTL = relativeTTL;
            this.lastUsage = lastUsage;
            this.idValue = idValue;
        }

        public boolean isExpired() {
            long now = System.currentTimeMillis();
            return this.absoluteTTL < now || this.relativeTTL < now - this.lastUsage;
        }

        public String getValue() {
            return this.idValue;
        }
    }
}

