/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.exceptions.InternalException;

public class DateAttributeSyntax
implements AttributeValueSyntax<LocalDate> {
    public static final String ID = "date";
    public static List<String> ACCEPTABLE_FORMATS = Arrays.asList("yyyy-MM-dd", "dd-MM-yyyy", "ddMMyy", "dd.MM.yyyy", "ddMMyyyy", "dd/MM/yyyy");
    private static final Logger log = Log.getLogger((String)"unity.server.core", DateAttributeSyntax.class);

    public String getValueSyntaxId() {
        return ID;
    }

    public JsonNode getSerializedConfiguration() {
        return Constants.MAPPER.createObjectNode();
    }

    public void setSerializedConfiguration(JsonNode json) {
    }

    public void validate(LocalDate value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
    }

    public boolean areEqual(LocalDate value, Object another) {
        return value == null ? null == another : value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public LocalDate convertFromString(String stringRepresentation) {
        for (String format : ACCEPTABLE_FORMATS) {
            try {
                return LocalDate.parse(stringRepresentation, DateTimeFormatter.ofPattern(format));
            }
            catch (Exception e) {
                log.trace("Can not parse date " + stringRepresentation + " using format: " + format, (Throwable)e);
            }
        }
        throw new InternalException("Can not parse date " + stringRepresentation + " using standard date formats");
    }

    public String convertToString(LocalDate value) {
        return value.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public boolean isUserVerifiable() {
        return false;
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<LocalDate> {
        public Factory() {
            super(DateAttributeSyntax.ID, DateAttributeSyntax::new);
        }
    }
}

