/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.JsonUtil;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.stdext.utils.EmailUtils;
import pl.edu.icm.unity.types.basic.VerifiableEmail;
import pl.edu.icm.unity.types.confirmation.EmailConfirmationConfiguration;

public class VerifiableEmailAttributeSyntax
implements AttributeValueSyntax<VerifiableEmail> {
    public static final String ID = "verifiableEmail";
    private EmailConfirmationConfiguration emailConfirmationConfiguration;

    public String getValueSyntaxId() {
        return ID;
    }

    public boolean areEqual(VerifiableEmail value, Object another) {
        return value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public void validate(VerifiableEmail value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        String error = EmailUtils.validate(value.getValue());
        if (error != null) {
            throw new IllegalAttributeValueException(value.getValue() + ": " + error);
        }
    }

    public JsonNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        if (this.getEmailConfirmationConfiguration().isPresent()) {
            main.set("emailConfirmationConfiguration", (JsonNode)this.getEmailConfirmationConfiguration().get().toJson());
        }
        return main;
    }

    public void setSerializedConfiguration(JsonNode json) {
        if (JsonUtil.notNull((JsonNode)json, (String)"emailConfirmationConfiguration")) {
            this.setEmailConfirmationConfiguration(new EmailConfirmationConfiguration((ObjectNode)json.get("emailConfirmationConfiguration")));
        }
    }

    public boolean isEmailVerifiable() {
        return true;
    }

    public boolean isUserVerifiable() {
        return true;
    }

    public VerifiableEmail convertFromString(String stringRepresentation) {
        return new VerifiableEmail((JsonNode)JsonUtil.parse((String)stringRepresentation));
    }

    public String convertToString(VerifiableEmail value) {
        return JsonUtil.serialize((JsonNode)value.toJson());
    }

    public String serializeSimple(VerifiableEmail value) {
        return value.getValue();
    }

    public VerifiableEmail deserializeSimple(String value) throws IllegalAttributeValueException {
        VerifiableEmail ret = EmailUtils.convertFromString(value);
        this.validate(ret);
        return ret;
    }

    public void setEmailConfirmationConfiguration(EmailConfirmationConfiguration confirmationConfiguration) {
        this.emailConfirmationConfiguration = confirmationConfiguration;
    }

    public Optional<EmailConfirmationConfiguration> getEmailConfirmationConfiguration() {
        return Optional.ofNullable(this.emailConfirmationConfiguration);
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<VerifiableEmail> {
        public Factory() {
            super(VerifiableEmailAttributeSyntax.ID, VerifiableEmailAttributeSyntax::new);
        }
    }
}

