/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.stdext.attr.DateTimeAttributeSyntax;

public class ZonedDateTimeAttributeSyntax
implements AttributeValueSyntax<ZonedDateTime> {
    public static final String ID = "zonedDatetime";
    public static final List<String> ACCEPTABLE_FORMATS = DateTimeAttributeSyntax.ACCEPTABLE_FORMATS.stream().map(f -> f + "xxx['['VV']'][X]").collect(Collectors.toList());
    private static final Logger log = Log.getLogger((String)"unity.server.core", ZonedDateTimeAttributeSyntax.class);

    public String getValueSyntaxId() {
        return ID;
    }

    public JsonNode getSerializedConfiguration() {
        return Constants.MAPPER.createObjectNode();
    }

    public void setSerializedConfiguration(JsonNode json) {
    }

    public void validate(ZonedDateTime value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
    }

    public boolean areEqual(ZonedDateTime value, Object another) {
        return value == null ? null == another : value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public ZonedDateTime convertFromString(String stringRepresentation) {
        for (String format : ACCEPTABLE_FORMATS) {
            try {
                return ZonedDateTime.parse(stringRepresentation, DateTimeFormatter.ofPattern(format));
            }
            catch (Exception e) {
                log.trace("Can not parse zoned datetime " + stringRepresentation + " using format: " + format, (Throwable)e);
            }
        }
        throw new InternalException("Can not parse zoned datetime " + stringRepresentation + " using standard datetime formats");
    }

    public String convertToString(ZonedDateTime value) {
        return value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public boolean isUserVerifiable() {
        return false;
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<ZonedDateTime> {
        public Factory() {
            super(ZonedDateTimeAttributeSyntax.ID, ZonedDateTimeAttributeSyntax::new);
        }
    }
}

