/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.Searchable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;
import pl.edu.icm.unity.engine.api.utils.CacheProvider;

@Component
public class AuthnSMSCounter {
    private static final String CACHE_ID = "AuthnSMSCounter";
    private Ehcache smsReqCache;

    @Autowired
    public AuthnSMSCounter(CacheProvider cacheProvider) {
        CacheConfiguration cacheConfig = new CacheConfiguration(CACHE_ID, 0);
        Searchable searchable = new Searchable();
        searchable.values(true);
        cacheConfig.addSearchable(searchable);
        cacheConfig.setTimeToIdleSeconds(172800L);
        cacheConfig.setEternal(false);
        PersistenceConfiguration persistCfg = new PersistenceConfiguration();
        persistCfg.setStrategy("none");
        cacheConfig.persistence(persistCfg);
        this.smsReqCache = cacheProvider.getManager().addCacheIfAbsent((Ehcache)new Cache(cacheConfig));
    }

    public synchronized void incValue(AuthenticationSubject username) {
        Element element = this.smsReqCache.get((Object)username);
        int value = 1;
        if (element != null && element.getObjectValue() != null) {
            int old = Integer.parseInt(element.getObjectValue().toString());
            value = old + 1;
        }
        this.smsReqCache.put(new Element((Object)username, (Object)value));
    }

    public synchronized boolean reset(AuthenticationSubject username) {
        return this.smsReqCache.remove((Object)username);
    }

    public synchronized int getValue(AuthenticationSubject username) {
        Element element = this.smsReqCache.get((Object)username);
        if (element != null && element.getObjectValue() != null) {
            return Integer.parseInt(element.getObjectValue().toString());
        }
        return 0;
    }
}

