/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;
import pl.edu.icm.unity.engine.api.attributes.NullAttributeValueException;

public class DateTimeAttributeSyntax
implements AttributeValueSyntax<LocalDateTime> {
    public static final String ID = "datetime";
    public static List<String> ACCEPTABLE_FORMATS = Arrays.asList("yyyy-MM-dd['T'][ ]HH:mm:ss", "dd-MM-yyyy['T'][ ]HH-mm-ss", "ddMMyy['T'][ ]HHmmss", "dd.MM.yyyy['T'][ ]HH.mm.ss", "ddMMyyyy['T'][ ]HHmmss", "dd/MM/yyyy['T'][ ]HH/mm/ss");
    private static final Logger log = Log.getLogger((String)"unity.server.core", DateTimeAttributeSyntax.class);

    public String getValueSyntaxId() {
        return ID;
    }

    public JsonNode getSerializedConfiguration() {
        return Constants.MAPPER.createObjectNode();
    }

    public void setSerializedConfiguration(JsonNode json) {
    }

    public void validate(LocalDateTime value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new NullAttributeValueException();
        }
    }

    public boolean areEqual(LocalDateTime value, Object another) {
        return value == null ? null == another : value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public LocalDateTime convertFromString(String stringRepresentation) {
        for (String format : ACCEPTABLE_FORMATS) {
            try {
                return LocalDateTime.parse(stringRepresentation, DateTimeFormatter.ofPattern(format));
            }
            catch (Exception e) {
                log.trace("Can not parse datetime " + stringRepresentation + " using format: " + format, (Throwable)e);
            }
        }
        throw new InternalException("Can not parse datetime " + stringRepresentation + " using standard date formats");
    }

    public String convertToString(LocalDateTime value) {
        return value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public boolean isUserVerifiable() {
        return false;
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<LocalDateTime> {
        public Factory() {
            super(DateTimeAttributeSyntax.ID, DateTimeAttributeSyntax::new);
        }
    }
}

