/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.stdext.attr.AbstractStringAttributeSyntax;

public class EnumAttributeSyntax
extends AbstractStringAttributeSyntax {
    public static final String ID = "enumeration";
    private Set<String> allowed;

    public EnumAttributeSyntax() {
    }

    public EnumAttributeSyntax(String ... allowed) {
        this.setAllowed(allowed);
    }

    public EnumAttributeSyntax(Set<String> allowed) {
        this.setAllowed(allowed);
    }

    public static <T extends Enum<T>> List<T> getEnumValues(Class<T> type, List<String> vals) {
        if (vals == null) {
            return null;
        }
        ArrayList<Enum> ret = new ArrayList<Enum>();
        HashMap<String, Enum> enumVals = new HashMap<String, Enum>();
        Enum[] constants = (Enum[])type.getEnumConstants();
        for (Enum label : constants) {
            enumVals.put(label.name(), label);
        }
        for (String val : vals) {
            ret.add((Enum)enumVals.get(val));
        }
        return ret;
    }

    public Set<String> getAllowed() {
        return this.allowed;
    }

    public void setAllowed(String ... allowed) {
        if (allowed.length == 0) {
            throw new IllegalArgumentException("At least one enumeration value must be defined");
        }
        this.allowed = new HashSet<String>(allowed.length);
        for (String allow : allowed) {
            this.allowed.add(allow);
        }
        this.allowed = Collections.unmodifiableSet(this.allowed);
    }

    public void setAllowed(Set<String> allowed) {
        if (allowed.isEmpty()) {
            throw new IllegalArgumentException("At least one enumeration value must be defined");
        }
        this.allowed = new HashSet<String>(allowed.size());
        for (String allow : allowed) {
            this.allowed.add(allow);
        }
        this.allowed = Collections.unmodifiableSet(this.allowed);
    }

    public JsonNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        ArrayNode allow = main.putArray("allowed");
        for (String a : this.allowed) {
            allow.add(a);
        }
        return main;
    }

    public void setSerializedConfiguration(JsonNode jsonN) {
        ArrayNode allow = (ArrayNode)jsonN.get("allowed");
        this.allowed = new HashSet<String>(allow.size());
        for (int i = 0; i < allow.size(); ++i) {
            this.allowed.add(allow.get(i).asText());
        }
        this.allowed = Collections.unmodifiableSet(this.allowed);
    }

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(String value) throws IllegalAttributeValueException {
        if (this.allowed == null) {
            throw new IllegalAttributeValueException("Trying to validate enum attribute value on not configured syntax");
        }
        if (!this.allowed.contains(value)) {
            throw new IllegalAttributeValueException("The value is not a valid enumeration element");
        }
    }

    public int getMaxSize() {
        return Collections.max(this.allowed, Comparator.comparing(String::length)).length();
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<String> {
        public Factory() {
            super(EnumAttributeSyntax.ID, EnumAttributeSyntax::new);
        }
    }
}

