/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.AttributeValueSyntax;

public class FloatingPointAttributeSyntax
implements AttributeValueSyntax<Double> {
    public static final String ID = "floatingPoint";
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;

    public ObjectNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        main.put("min", this.getMin());
        main.put("max", this.getMax());
        return main;
    }

    public void setSerializedConfiguration(JsonNode jsonN) {
        this.min = jsonN.get("min").asDouble();
        this.max = jsonN.get("max").asDouble();
    }

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(Double value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        if (value < this.min) {
            throw new IllegalAttributeValueException("Value (" + value + ") is too small, must be at least " + this.min);
        }
        if (value > this.max) {
            throw new IllegalAttributeValueException("Value (" + value + ") is too big, must be not greater than " + this.max);
        }
    }

    public boolean areEqual(Double value, Object another) {
        return value == null ? null == another : value.equals(another);
    }

    public int hashCode(Object value) {
        return value.hashCode();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) throws WrongArgumentException {
        if (min > this.max) {
            throw new WrongArgumentException("Minimum must not be less then the maximum");
        }
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) throws WrongArgumentException {
        if (max < this.min) {
            throw new WrongArgumentException("Maximum must not be less then the minimum");
        }
        this.max = max;
    }

    public boolean isEmailVerifiable() {
        return false;
    }

    public Double convertFromString(String stringRepresentation) {
        try {
            return Double.parseDouble(stringRepresentation);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong number format", e);
        }
    }

    public String convertToString(Double value) {
        return value.toString();
    }

    public boolean isUserVerifiable() {
        return false;
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<Double> {
        public Factory() {
            super(FloatingPointAttributeSyntax.ID, FloatingPointAttributeSyntax::new);
        }
    }
}

