/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.attribute.image.LinkableImage;
import pl.edu.icm.unity.base.attribute.image.UnityImage;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.engine.api.attributes.PublicAttributeContent;
import pl.edu.icm.unity.engine.api.attributes.PublicAttributeInfo;
import pl.edu.icm.unity.engine.api.attributes.PublicAttributeSpec;
import pl.edu.icm.unity.engine.api.server.AdvertisedAddressProvider;
import pl.edu.icm.unity.stdext.attr.BaseImageAttributeSyntax;
import pl.edu.icm.unity.stdext.utils.ImageValidatorUtil;

public class PublicLinkableImageSyntax
extends BaseImageAttributeSyntax<LinkableImage> {
    public static final String ID = "publicLinkableImage";
    private static final String PUBLIC_IMAGE_PATH = "/unitygw/content/";
    private final URL serverAdvertisedAddress;

    public PublicLinkableImageSyntax(URL serverAdvertisedAddress) {
        this.serverAdvertisedAddress = serverAdvertisedAddress;
    }

    public String getValueSyntaxId() {
        return ID;
    }

    public void validate(LinkableImage value) throws IllegalAttributeValueException {
        if (value.getUnityImage() != null) {
            ImageValidatorUtil.validate(this.getConfig(), value.getUnityImage());
        }
    }

    public LinkableImage convertFromString(String stringRepresentation) {
        try {
            return LinkableImage.valueOf((String)stringRepresentation);
        }
        catch (MalformedURLException e) {
            throw new InternalException("Invalid URL addres.", (Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException("Error encoding image from string.", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalException("Error encoding to linkable image.", (Throwable)e);
        }
    }

    public String convertToString(LinkableImage value) {
        return value.toJsonString();
    }

    public String serializeSimple(LinkableImage value) {
        if (value.getUnityImage() != null) {
            return this.getImageUrl(value);
        }
        if (value.getUrl() != null) {
            return value.getUrl().toExternalForm();
        }
        return "";
    }

    public String getImageUrl(LinkableImage value) {
        return this.getServletUrl() + value.getExternalId();
    }

    private String getServletUrl() {
        return this.serverAdvertisedAddress.toExternalForm() + PUBLIC_IMAGE_PATH;
    }

    public LinkableImage deserializeSimple(String value) throws IllegalAttributeValueException {
        if (!StringUtils.hasLength((String)value)) {
            return LinkableImage.EMPTY;
        }
        try {
            URL url = new URL(value);
            UUID externalId = null;
            if (value.startsWith(this.getServletUrl())) {
                String externalIdString = url.getPath().replace(PUBLIC_IMAGE_PATH, "");
                externalId = UUID.fromString(externalIdString);
            }
            return new LinkableImage(url, externalId);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalAttributeValueException(value + " can not be deserialized to " + this.getValueSyntaxId(), (Throwable)e);
        }
    }

    public Optional<PublicAttributeSpec> publicExposureSpec() {
        return Optional.of(new PublicLinkableImageSharingSpec());
    }

    private class PublicLinkableImageSharingSpec
    implements PublicAttributeSpec {
        private PublicLinkableImageSharingSpec() {
        }

        public PublicAttributeInfo getInfo(String stringRepresentation) {
            LinkableImage value = PublicLinkableImageSyntax.this.convertFromString(stringRepresentation);
            String externalId = value.getExternalId() == null ? null : value.getExternalId().toString();
            return new PublicAttributeInfo(externalId);
        }

        public PublicAttributeSpec.PublicAttributeContentProvider getContentProvider() {
            return stringRepresentation -> {
                LinkableImage value = PublicLinkableImageSyntax.this.convertFromString(stringRepresentation);
                UnityImage image = value.getUnityImage();
                return new PublicAttributeContent(image.getImage(), image.getType().getMimeType());
            };
        }
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<LinkableImage> {
        public Factory(AdvertisedAddressProvider advertisedAddressProvider) {
            super(PublicLinkableImageSyntax.ID, () -> new PublicLinkableImageSyntax(advertisedAddressProvider.get()));
        }
    }
}

