/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.attr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;
import pl.edu.icm.unity.engine.api.attributes.AbstractAttributeValueSyntaxFactory;
import pl.edu.icm.unity.stdext.attr.AbstractStringAttributeSyntax;

public class StringAttributeSyntax
extends AbstractStringAttributeSyntax {
    public static final String ID = "string";
    private int minLength = 0;
    private int maxLength = 10240;
    private Pattern pattern = null;
    private boolean editWithTextArea;

    public String getValueSyntaxId() {
        return ID;
    }

    public JsonNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        main.put("regexp", this.getRegexp());
        main.put("minLength", this.getMinLength());
        main.put("maxLength", this.getMaxLength());
        main.put("editWithTextArea", String.valueOf(this.editWithTextArea));
        return main;
    }

    public void setSerializedConfiguration(JsonNode jsonN) {
        this.setRegexp(jsonN.get("regexp").asText());
        this.minLength = jsonN.get("minLength").asInt();
        this.maxLength = jsonN.get("maxLength").asInt();
        this.editWithTextArea = jsonN.has("editWithTextArea") && jsonN.get("editWithTextArea").asBoolean();
    }

    public void validate(String value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        if (value.length() < this.minLength) {
            throw new IllegalAttributeValueException("Value length (" + value.length() + ") is too small, must be at least " + this.minLength);
        }
        if (value.length() > this.maxLength) {
            throw new IllegalAttributeValueException("Value length (" + value.length() + ") is too big, must be not greater than " + this.maxLength);
        }
        if (this.pattern != null && !this.pattern.matcher(value).matches()) {
            throw new IllegalAttributeValueException("Value must match the regular expression: " + this.getRegexp());
        }
    }

    public String getRegexp() {
        return this.pattern == null ? "" : this.pattern.pattern();
    }

    public void setRegexp(String regexp) {
        this.pattern = "".equals(regexp) ? null : Pattern.compile(regexp);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) throws WrongArgumentException {
        if (minLength > this.maxLength) {
            throw new WrongArgumentException("Minimal string length must not be less then the maximal");
        }
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMaxSize() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) throws WrongArgumentException {
        if (maxLength < this.minLength) {
            throw new WrongArgumentException("Maximal string length must not be less then the minimal");
        }
        this.maxLength = maxLength;
    }

    public boolean isEditWithTextArea() {
        return this.editWithTextArea;
    }

    public void setEditWithTextArea(boolean editWithTextArea) {
        this.editWithTextArea = editWithTextArea;
    }

    @Component
    public static class Factory
    extends AbstractAttributeValueSyntaxFactory<String> {
        public Factory() {
            super(StringAttributeSyntax.ID, StringAttributeSyntax::new);
        }
    }
}

