/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.json.JsonUtil;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialResetSettings;
import pl.edu.icm.unity.stdext.credential.pass.ScryptParams;

public class PasswordCredential {
    public static final long MAX_AGE_UNDEF = 6220800000000L;
    private int minLength = 1;
    private int historySize = 1;
    private int minClassesNum = 1;
    private boolean denySequences = false;
    private boolean allowLegacy = true;
    private int minScore = 10;
    private long maxAge = 6220800000000L;
    private ScryptParams scryptParams;
    private PasswordCredentialResetSettings passwordResetSettings = new PasswordCredentialResetSettings();

    public ObjectNode getSerializedConfiguration() throws InternalException {
        ObjectNode root = Constants.MAPPER.createObjectNode();
        root.put("minLength", this.minLength);
        root.put("historySize", this.historySize);
        root.put("minClassesNum", this.minClassesNum);
        root.put("maxAge", this.maxAge);
        root.put("denySequences", this.denySequences);
        root.put("allowLegacy", this.allowLegacy);
        root.putPOJO("scryptParams", (Object)this.scryptParams);
        root.put("minScore", this.minScore);
        ObjectNode resetNode = root.putObject("resetSettings");
        this.passwordResetSettings.serializeTo(resetNode);
        return root;
    }

    public void setSerializedConfiguration(ObjectNode root) throws InternalException {
        JsonNode scryptParamsNode;
        this.minLength = root.get("minLength").asInt();
        if (this.minLength <= 0 || this.minLength > 100) {
            throw new InternalException("Minimal password length must be in range [1-100]");
        }
        this.historySize = root.get("historySize").asInt();
        if (this.historySize < 0 || this.historySize > 1000) {
            throw new InternalException("History size must be in range [0-1000]");
        }
        this.minClassesNum = root.get("minClassesNum").asInt();
        if (this.minClassesNum <= 0 || this.minClassesNum > 4) {
            throw new InternalException("Minimum classes number must be in range [1-4]");
        }
        this.maxAge = root.get("maxAge").asLong();
        if (this.maxAge <= 0L) {
            throw new InternalException("Maximum age must be positive");
        }
        this.denySequences = root.get("denySequences").asBoolean();
        JsonNode allowLegacyNode = root.get("allowLegacy");
        if (allowLegacyNode != null) {
            this.allowLegacy = allowLegacyNode.asBoolean();
        }
        this.scryptParams = (scryptParamsNode = root.get("scryptParams")) != null && !scryptParamsNode.isNull() ? (ScryptParams)Constants.MAPPER.convertValue((Object)scryptParamsNode, ScryptParams.class) : new ScryptParams();
        this.scryptParams.sanitize();
        JsonNode resetNode = root.get("resetSettings");
        if (resetNode != null) {
            this.passwordResetSettings.deserializeFrom((ObjectNode)resetNode);
        }
        this.minScore = JsonUtil.notNull((JsonNode)root, (String)"minScore") ? root.get("minScore").asInt() : 0;
    }

    public boolean hasStrongerRequirementsThen(PasswordCredential other) {
        if (this.minLength > other.minLength) {
            return true;
        }
        if (this.minClassesNum > other.minClassesNum) {
            return true;
        }
        if (this.denySequences && !other.denySequences) {
            return true;
        }
        if (!this.allowLegacy && other.allowLegacy) {
            return true;
        }
        if (this.minScore > other.minScore) {
            return true;
        }
        if (this.maxAge < other.maxAge) {
            return true;
        }
        return this.scryptParams.hasStrongerRequirementsThen(other.scryptParams);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    public int getMinClassesNum() {
        return this.minClassesNum;
    }

    public void setMinClassesNum(int minClassesNum) {
        this.minClassesNum = minClassesNum;
    }

    public boolean isDenySequences() {
        return this.denySequences;
    }

    public boolean isAllowLegacy() {
        return this.allowLegacy;
    }

    public void setAllowLegacy(boolean allowLegacy) {
        this.allowLegacy = allowLegacy;
    }

    public void setDenySequences(boolean denySequences) {
        this.denySequences = denySequences;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public ScryptParams getScryptParams() {
        return this.scryptParams;
    }

    public void setScryptParams(ScryptParams params) {
        this.scryptParams = params;
    }

    public PasswordCredentialResetSettings getPasswordResetSettings() {
        return this.passwordResetSettings;
    }

    public void setPasswordResetSettings(PasswordCredentialResetSettings passwordResetSettings) {
        this.passwordResetSettings = passwordResetSettings;
    }

    public int getMinScore() {
        return this.minScore;
    }

    public void setMinScore(int minScore) {
        this.minScore = minScore;
    }
}

