/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Date;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.InternalException;

public class PasswordExtraInfo {
    private Date lastChange;
    private String securityQuestion;

    private PasswordExtraInfo() {
    }

    public PasswordExtraInfo(Date lastChange, String securityQuestion) {
        this.lastChange = lastChange;
        this.securityQuestion = securityQuestion;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public static PasswordExtraInfo fromJson(String json) {
        PasswordExtraInfo ret = new PasswordExtraInfo();
        if (json == null || json.equals("")) {
            return ret;
        }
        try {
            JsonNode root = Constants.MAPPER.readTree(json);
            ret.setLastChange(new Date(root.get("lastChange").asLong()));
            if (root.has("question")) {
                ret.setSecurityQuestion(root.get("question").asText());
            }
            return ret;
        }
        catch (IOException e) {
            throw new InternalException("Can't deserialize extra credential information from JSON", (Throwable)e);
        }
    }

    public String toJson() {
        ObjectNode root = Constants.MAPPER.createObjectNode();
        root.put("lastChange", this.lastChange.getTime());
        if (this.securityQuestion != null) {
            root.put("question", this.securityQuestion);
        }
        try {
            return Constants.MAPPER.writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            throw new InternalException("Can't serialize extra credential information to JSON", (Throwable)e);
        }
    }
}

