/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredential;

class SMSCredentialDBState {
    private String value;
    private Date time;

    public SMSCredentialDBState(String value, long time) {
        this.value = value;
        this.setTime(new Date(time));
    }

    public SMSCredentialDBState() {
    }

    public static SMSCredentialDBState fromJson(String raw) throws InternalException {
        if (raw == null || raw.length() == 0) {
            return new SMSCredentialDBState(null, System.currentTimeMillis());
        }
        try {
            return (SMSCredentialDBState)Constants.MAPPER.readValue(raw, SMSCredentialDBState.class);
        }
        catch (Exception e) {
            throw new InternalException("Can't deserialize sms credential from JSON", (Throwable)e);
        }
    }

    public static String toJson(SMSCredential credential, String value, long time) {
        SMSCredentialDBState dbState = new SMSCredentialDBState(value, time);
        try {
            return Constants.MAPPER.writeValueAsString((Object)dbState);
        }
        catch (JsonProcessingException e) {
            throw new InternalException("Can't serialize sms credential to JSON", (Throwable)e);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
}

