/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import java.util.regex.Pattern;
import pl.edu.icm.unity.base.verifiable.VerifiableElementBase;
import pl.edu.icm.unity.base.verifiable.VerifiableMobileNumber;
import pl.edu.icm.unity.stdext.utils.ConfirmationUtils;

public class MobileNumberUtils {
    private static final int MAX_LENGTH = 15;
    public static final Pattern mobileNumberPattern = Pattern.compile("(\\+)?(\\d){3,15}");

    public static String validate(String value) {
        if (value == null) {
            return "null value is illegal";
        }
        if (value.length() > 15) {
            return "Value length (" + value.length();
        }
        if (!mobileNumberPattern.matcher(value).matches()) {
            return "Value must match the regular expression: " + mobileNumberPattern.toString();
        }
        return null;
    }

    public static VerifiableMobileNumber convertFromString(String stringRepresentationRaw) {
        VerifiableElementBase verifiableBase = ConfirmationUtils.convertFromString(stringRepresentationRaw);
        return (VerifiableMobileNumber)verifiableBase;
    }
}

