/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.cert;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.authn.AuthenticationMethod;
import pl.edu.icm.unity.base.authn.CredentialPublicInformation;
import pl.edu.icm.unity.base.authn.LocalCredentialState;
import pl.edu.icm.unity.base.entity.Entity;
import pl.edu.icm.unity.base.entity.EntityParam;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.identity.Identity;
import pl.edu.icm.unity.base.identity.IllegalIdentityValueException;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.EntityManagement;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.IllegalCredentialException;
import pl.edu.icm.unity.engine.api.authn.LocalAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalVerificator;
import pl.edu.icm.unity.engine.api.authn.remote.AuthenticationTriggeringContext;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.stdext.credential.cert.CertificateExchange;

@PrototypeComponent
public class CertificateVerificator
extends AbstractLocalVerificator
implements CertificateExchange {
    private static final Logger log = Log.getLogger((String)"unity.server.authn", CertificateVerificator.class);
    private static final String[] IDENTITY_TYPES = new String[]{"x500Name"};
    public static final String NAME = "certificate";
    public static final String DESC = "Verifies certificates";
    private EntityManagement idMan;

    @Autowired
    public CertificateVerificator(@Qualifier(value="insecure") EntityManagement idMan) {
        super(NAME, DESC, "certificate exchange", false);
        this.idMan = idMan;
    }

    public String getSerializedConfiguration() {
        return "";
    }

    public void setSerializedConfiguration(String json) {
    }

    public String prepareCredential(String rawCredential, String currentCredential, boolean verify) throws IllegalCredentialException {
        return "";
    }

    public CredentialPublicInformation checkCredentialState(String currentCredential) {
        return new CredentialPublicInformation(LocalCredentialState.correct, "");
    }

    @Override
    public AuthenticationResult checkCertificate(X509Certificate[] chain, String formForUnknown, boolean enableAssociation, AuthenticationTriggeringContext triggeringContext) {
        String identity = chain[0].getSubjectX500Principal().getName();
        try {
            EntityWithCredential resolved = this.identityResolver.resolveIdentity(identity, IDENTITY_TYPES, this.credentialName);
            AuthenticatedEntity entity = new AuthenticatedEntity(Long.valueOf(resolved.getEntityId()), X500NameUtils.getReadableForm((String)identity), null);
            return LocalAuthenticationResult.successful((AuthenticatedEntity)entity, (AuthenticationMethod)this.getAuthenticationMethod());
        }
        catch (IllegalIdentityValueException e) {
            log.warn("Checking certificate failed", (Throwable)e);
            return LocalAuthenticationResult.failed((Exception)((Object)e), (AuthenticationResult.DenyReason)AuthenticationResult.DenyReason.undefinedCredential);
        }
        catch (Exception e) {
            log.warn("Checking certificate failed", (Throwable)e);
            return LocalAuthenticationResult.failed((Exception)e);
        }
    }

    public String invalidate(String currentCredential) {
        throw new IllegalStateException("This credential doesn't support invalidation");
    }

    private boolean checkX500Id(EntityParam entity) throws EngineException {
        Entity entityRes = this.idMan.getEntity(entity);
        if (entityRes == null) {
            return false;
        }
        List ids = entityRes.getIdentities();
        for (Identity id : ids) {
            if (!id.getTypeId().equals("x500Name")) continue;
            return true;
        }
        return false;
    }

    public boolean isCredentialSet(EntityParam entity) throws EngineException {
        return this.checkX500Id(entity);
    }

    public boolean isCredentialDefinitionChagneOutdatingCredentials(String newCredentialDefinition) {
        return false;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.SWK;
    }

    @Component
    public static class Factory
    extends AbstractLocalCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<CertificateVerificator> factory) {
            super(CertificateVerificator.NAME, CertificateVerificator.DESC, false, factory);
        }
    }
}

