/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Deque;
import java.util.LinkedList;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredential;
import pl.edu.icm.unity.stdext.credential.pass.PasswordInfo;

class PasswordCredentialDBState {
    private Deque<PasswordInfo> passwords;
    private boolean outdated;
    private String outdatedReason;
    private String securityQuestion;
    private PasswordInfo answer;

    public PasswordCredentialDBState(Deque<PasswordInfo> passwords, boolean outdated, String outdatedReason, String securityQuestion, PasswordInfo answer) {
        this.passwords = passwords;
        this.outdated = outdated;
        this.outdatedReason = outdatedReason;
        this.securityQuestion = securityQuestion;
        this.answer = answer;
    }

    protected PasswordCredentialDBState() {
    }

    public Deque<PasswordInfo> getPasswords() {
        return this.passwords;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public String getOutdatedReason() {
        return this.outdatedReason;
    }

    public PasswordInfo getAnswer() {
        return this.answer;
    }

    public static PasswordCredentialDBState fromJson(String raw) throws InternalException {
        if (raw == null || raw.length() == 0) {
            return new PasswordCredentialDBState(new LinkedList<PasswordInfo>(), false, null, null, null);
        }
        try {
            return (PasswordCredentialDBState)Constants.MAPPER.readValue(raw, PasswordCredentialDBState.class);
        }
        catch (Exception e) {
            throw new InternalException("Can't deserialize password credential from JSON", (Throwable)e);
        }
    }

    public static String toJson(PasswordCredential credential, Deque<PasswordInfo> currentPasswords, int questionIndex, PasswordInfo questionAnswer) {
        String securityQuestion = null;
        if (credential.getPasswordResetSettings().isEnabled() && credential.getPasswordResetSettings().isRequireSecurityQuestion()) {
            securityQuestion = credential.getPasswordResetSettings().getQuestions().get(questionIndex);
        }
        PasswordCredentialDBState dbState = new PasswordCredentialDBState(currentPasswords, false, null, securityQuestion, questionAnswer);
        try {
            return Constants.MAPPER.writeValueAsString((Object)dbState);
        }
        catch (JsonProcessingException e) {
            throw new InternalException("Can't serialize password credential to JSON", (Throwable)e);
        }
    }
}

