/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.pass;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import pl.edu.icm.unity.base.exceptions.InternalException;

public class PasswordCredentialResetSettings {
    private boolean enabled = false;
    private boolean requireSecurityQuestion = false;
    private int codeLength = 4;
    private List<String> questions = new ArrayList<String>();
    private String emailSecurityCodeMsgTemplate;
    private String mobileSecurityCodeMsgTemplate;
    private ConfirmationMode confirmationMode = ConfirmationMode.NothingRequire;

    public PasswordCredentialResetSettings() {
    }

    public PasswordCredentialResetSettings(ObjectNode node) {
        this.deserializeFrom(node);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void setRequireSecurityQuestion(boolean requireSecurityQuestion) {
        this.requireSecurityQuestion = requireSecurityQuestion;
    }

    public boolean isRequireEmailConfirmation() {
        return this.confirmationMode.equals((Object)ConfirmationMode.RequireEmail) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailAndMobile);
    }

    public boolean isRequireMobileConfirmation() {
        return this.confirmationMode.equals((Object)ConfirmationMode.RequireMobile) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailAndMobile);
    }

    public boolean isRequireSecurityQuestion() {
        return this.requireSecurityQuestion;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    public List<String> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<String> questions) {
        this.questions = questions;
    }

    public String getEmailSecurityCodeMsgTemplate() {
        return this.emailSecurityCodeMsgTemplate;
    }

    public void setEmailSecurityCodeMsgTemplate(String emailSecurityCodeMsgTemplate) {
        this.emailSecurityCodeMsgTemplate = emailSecurityCodeMsgTemplate;
    }

    public String getMobileSecurityCodeMsgTemplate() {
        return this.mobileSecurityCodeMsgTemplate;
    }

    public void setMobileSecurityCodeMsgTemplate(String mobileSecurityCodeMsgTemplate) {
        this.mobileSecurityCodeMsgTemplate = mobileSecurityCodeMsgTemplate;
    }

    public void serializeTo(ObjectNode node) {
        node.put("enable", this.enabled);
        if (!this.enabled) {
            return;
        }
        node.put("codeLength", this.codeLength);
        node.put("confirmationMode", this.confirmationMode.toString());
        node.put("requireSecurityQuestion", this.requireSecurityQuestion);
        ArrayNode questionsNode = node.putArray("questions");
        for (String question : this.questions) {
            questionsNode.add(question);
        }
        node.put("emailSecurityCodeMsgTemplate", this.emailSecurityCodeMsgTemplate);
        node.put("mobileSecurityCodeMsgTemplate", this.mobileSecurityCodeMsgTemplate);
    }

    public void deserializeFrom(ObjectNode node) {
        this.enabled = node.get("enable").asBoolean();
        if (!this.enabled) {
            return;
        }
        this.codeLength = node.get("codeLength").asInt();
        this.confirmationMode = ConfirmationMode.valueOf(node.get("confirmationMode").asText());
        this.requireSecurityQuestion = node.get("requireSecurityQuestion").asBoolean();
        ArrayNode questionsNode = (ArrayNode)node.get("questions");
        if (this.requireSecurityQuestion) {
            if (questionsNode == null || questionsNode.size() == 0) {
                throw new InternalException("At least one security question must be defined if questions are required");
            }
            for (int i = 0; i < questionsNode.size(); ++i) {
                this.questions.add(questionsNode.get(i).asText());
            }
        }
        this.emailSecurityCodeMsgTemplate = node.has("emailSecurityCodeMsgTemplate") && !node.get("emailSecurityCodeMsgTemplate").isNull() ? node.get("emailSecurityCodeMsgTemplate").asText() : "PasswordResetCode";
        if (node.has("mobileSecurityCodeMsgTemplate") && !node.get("mobileSecurityCodeMsgTemplate").isNull()) {
            this.mobileSecurityCodeMsgTemplate = node.get("mobileSecurityCodeMsgTemplate").asText();
        }
        this.validate();
    }

    public void validate() {
        if ((this.confirmationMode.equals((Object)ConfirmationMode.RequireEmail) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailAndMobile) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailOrMobile)) && (this.emailSecurityCodeMsgTemplate == null || this.emailSecurityCodeMsgTemplate.isEmpty())) {
            throw new InternalException("Email reset code message template must be defined");
        }
        if ((this.confirmationMode.equals((Object)ConfirmationMode.RequireMobile) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailAndMobile) || this.confirmationMode.equals((Object)ConfirmationMode.RequireEmailOrMobile)) && (this.mobileSecurityCodeMsgTemplate == null || this.mobileSecurityCodeMsgTemplate.isEmpty())) {
            throw new InternalException("Mobile reset code message template must be defined");
        }
        if (this.confirmationMode.equals((Object)ConfirmationMode.NothingRequire) && !this.requireSecurityQuestion) {
            throw new InternalException("Security question must be defined or another option of confirmation method must be choosen");
        }
    }

    public ConfirmationMode getConfirmationMode() {
        return this.confirmationMode;
    }

    public void setConfirmationMode(ConfirmationMode confirmationMode) {
        this.confirmationMode = confirmationMode;
    }

    public static enum ConfirmationMode {
        RequireEmail,
        RequireMobile,
        RequireEmailAndMobile,
        RequireEmailOrMobile,
        NothingRequire;

    }
}

