/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;

@Component
class AuthnSMSCounter {
    private final Cache<AuthenticationSubject, Integer> smsReqCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(48L)).build();

    AuthnSMSCounter() {
    }

    synchronized void incValue(AuthenticationSubject username) {
        Integer lastValue = (Integer)this.smsReqCache.getIfPresent((Object)username);
        int value = lastValue != null ? lastValue + 1 : 1;
        this.smsReqCache.put((Object)username, (Object)value);
    }

    synchronized boolean reset(AuthenticationSubject username) {
        boolean wasPresent = this.smsReqCache.getIfPresent((Object)username) != null;
        this.smsReqCache.invalidate((Object)username);
        return wasPresent;
    }

    synchronized int getValue(AuthenticationSubject username) {
        Integer value = (Integer)this.smsReqCache.getIfPresent((Object)username);
        return value == null ? 0 : value;
    }
}

