/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.credential.sms;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.authn.AuthenticationMethod;
import pl.edu.icm.unity.base.authn.CredentialPublicInformation;
import pl.edu.icm.unity.base.authn.LocalCredentialState;
import pl.edu.icm.unity.base.entity.EntityParam;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.json.JsonUtil;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.IllegalCredentialException;
import pl.edu.icm.unity.engine.api.authn.LocalAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.local.AbstractLocalVerificator;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.confirmation.SMSCode;
import pl.edu.icm.unity.engine.api.msg.LocaleHelper;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.engine.api.utils.CodeGenerator;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.stdext.credential.sms.AuthnSMSCounter;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredential;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialDBState;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialExtraInfo;
import pl.edu.icm.unity.stdext.credential.sms.SMSCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.sms.SMSExchange;

@PrototypeComponent
public class SMSVerificator
extends AbstractLocalVerificator
implements SMSExchange {
    private static final Logger log = Log.getLogger((String)"unity.server.authn", SMSVerificator.class);
    public static final String NAME = "sms";
    public static final String DESC = "Verifies sms";
    public static final String[] IDENTITY_TYPES = new String[]{"userName", "email"};
    private SMSCredential credential = new SMSCredential();
    private NotificationProducer notificationProducer;
    private CredentialHelper credentialHelper;
    private AuthnSMSCounter smslimitCache;

    @Autowired
    public SMSVerificator(NotificationProducer notificationProducer, CredentialHelper credentialHelper, AuthnSMSCounter smslimitCache) {
        super(NAME, DESC, "sms exchange", true);
        this.notificationProducer = notificationProducer;
        this.credentialHelper = credentialHelper;
        this.smslimitCache = smslimitCache;
    }

    public String prepareCredential(String rawCredential, String currentCredential, boolean verifyNew) throws IllegalCredentialException, InternalException {
        return SMSCredentialDBState.toJson(this.credential, rawCredential, System.currentTimeMillis());
    }

    public CredentialPublicInformation checkCredentialState(String currentCredential) throws InternalException {
        SMSCredentialDBState parsedCred = SMSCredentialDBState.fromJson(currentCredential);
        if (parsedCred.getValue() == null || parsedCred.getValue().isEmpty()) {
            return new CredentialPublicInformation(LocalCredentialState.notSet, "");
        }
        SMSCredentialExtraInfo pei = new SMSCredentialExtraInfo(parsedCred.getTime(), parsedCred.getValue());
        String extraInfo = pei.toJson();
        return new CredentialPublicInformation(LocalCredentialState.correct, extraInfo);
    }

    public String invalidate(String currentCredential) {
        throw new IllegalStateException("This credential doesn't support invalidation");
    }

    public String getSerializedConfiguration() throws InternalException {
        return JsonUtil.serialize((JsonNode)this.credential.getSerializedConfiguration());
    }

    public void setSerializedConfiguration(String json) throws InternalException {
        this.credential.setSerializedConfiguration(JsonUtil.parse((String)json));
    }

    @Override
    public SMSCode sendCode(AuthenticationSubject subject, boolean force) throws EngineException {
        if (this.isAuthSMSLimitExceeded(subject)) {
            if (force) {
                log.warn("Forcing sending authn sms code to the user " + String.valueOf(subject) + ", but authn sms limit is exceeded");
            } else {
                log.warn("Authn sms limit to the user " + String.valueOf(subject) + " is exceeded, skipping send authn sms");
                return null;
            }
        }
        this.smslimitCache.incValue(subject);
        EntityWithCredential resolved = null;
        try {
            resolved = this.identityResolver.resolveSubject(subject, IDENTITY_TYPES, this.credentialName);
        }
        catch (Exception e) {
            log.info("The user for sms authN can not be found: " + String.valueOf(subject), (Throwable)e);
            return null;
        }
        String credentialValue = resolved.getCredentialValue();
        if (credentialValue == null) {
            log.info("The user {} does not have {} credential defined, skipping sending authentication code", (Object)subject, (Object)this.credentialName);
            return null;
        }
        SMSCredentialDBState credState = SMSCredentialDBState.fromJson(credentialValue);
        String code = CodeGenerator.generateNumberCode((int)this.credential.getCodeLength());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("user", this.identityResolver.getDisplayedUserName(new EntityParam(Long.valueOf(resolved.getEntityId()))));
        Locale currentLocale = LocaleHelper.getLocale(null);
        String locale = currentLocale == null ? null : currentLocale.toString();
        this.notificationProducer.sendNotification(credState.getValue(), this.credential.getMessageTemplate(), params, locale);
        return new SMSCode(System.currentTimeMillis() + (long)(this.credential.getValidityTime() * 60 * 1000), code, credState.getValue());
    }

    @Override
    public AuthenticationResult verifyCode(SMSCode sentCode, String codeFromUser, AuthenticationSubject subject) {
        return this.verifyCodeInternal(sentCode, codeFromUser, subject);
    }

    private AuthenticationResult verifyCodeInternal(SMSCode sentCode, String codeFromUser, AuthenticationSubject subject) {
        EntityWithCredential resolved;
        if (sentCode == null) {
            return SMSVerificator.getGenericError();
        }
        try {
            resolved = this.identityResolver.resolveSubject(subject, IDENTITY_TYPES, this.credentialName);
        }
        catch (Exception e) {
            log.info("The user for sms authN can not be found: " + String.valueOf(subject), (Throwable)e);
            return SMSVerificator.getGenericError();
        }
        if (System.currentTimeMillis() > sentCode.getValidTo()) {
            log.info("SMS code provided by " + String.valueOf(subject) + " is invalid");
            return SMSVerificator.getGenericError();
        }
        if (codeFromUser == null || !sentCode.getValue().equals(codeFromUser)) {
            log.info("SMS code provided by " + String.valueOf(subject) + " is incorrect");
            return SMSVerificator.getGenericError();
        }
        AuthenticatedEntity ae = new AuthenticatedEntity(Long.valueOf(resolved.getEntityId()), subject, null);
        this.smslimitCache.reset(subject);
        return LocalAuthenticationResult.successful((AuthenticatedEntity)ae, (AuthenticationMethod)this.getAuthenticationMethod());
    }

    private static AuthenticationResult getGenericError() {
        return LocalAuthenticationResult.failed((AuthenticationResult.ResolvableError)new AuthenticationResult.ResolvableError("WebSMSRetrieval.wrongCode", new Object[0]));
    }

    @Override
    public SMSCredentialResetImpl getSMSCredentialResetBackend() {
        return new SMSCredentialResetImpl(this.notificationProducer, this.identityResolver, (LocalCredentialVerificator)this, this.credentialHelper, this.credentialName, this.credential.getSerializedConfiguration(), this.credential.getRecoverySettings());
    }

    @Override
    public boolean isAuthSMSLimitExceeded(AuthenticationSubject username) {
        return this.smslimitCache.getValue(username) >= this.credential.getAuthnSMSLimit();
    }

    public boolean isCredentialSet(EntityParam entity) throws EngineException {
        return this.credentialHelper.isCredentialSet(entity, this.credentialName);
    }

    public boolean isCredentialDefinitionChagneOutdatingCredentials(String newCredentialDefinition) {
        return false;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.SMS;
    }

    @Component
    public static class Factory
    extends AbstractLocalCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<SMSVerificator> factory) {
            super(SMSVerificator.NAME, SMSVerificator.DESC, false, factory);
        }
    }
}

