/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.identity;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.identity.IdentityParam;
import pl.edu.icm.unity.base.message.MessageSource;
import pl.edu.icm.unity.stdext.identity.AbstractStaticIdentityTypeProvider;

@Component
public class X500Identity
extends AbstractStaticIdentityTypeProvider {
    public static final String ID = "x500Name";

    public String getId() {
        return ID;
    }

    public String getDefaultDescriptionKey() {
        return "X500Identity.description";
    }

    public void validate(String value) {
        try {
            X500NameUtils.getX500Principal((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DN is invalid: " + e.getMessage(), e);
        }
    }

    public String getComparableValue(String from, String realm, String target) {
        return X500NameUtils.getComparableForm((String)from);
    }

    public String toPrettyStringNoPrefix(IdentityParam from) {
        return X500NameUtils.getReadableForm((String)from.getValue());
    }

    public String getHumanFriendlyDescription(MessageSource msg) {
        return msg.getMessage("X500Identity.description", new Object[0]);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public String getHumanFriendlyName(MessageSource msg) {
        return msg.getMessage("X500Identity.name", new Object[0]);
    }
}

