/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;

public class ImageConfiguration {
    private int maxWidth = Integer.MAX_VALUE;
    private int maxHeight = Integer.MAX_VALUE;
    private int maxSize = 0x100000;

    public JsonNode getSerializedConfiguration() {
        ObjectNode main = Constants.MAPPER.createObjectNode();
        main.put("maxWidth", this.getMaxWidth());
        main.put("maxHeight", this.getMaxHeight());
        main.put("maxSize", this.getMaxSize());
        return main;
    }

    public void setSerializedConfiguration(JsonNode jsonN) {
        this.maxWidth = jsonN.get("maxWidth").asInt();
        this.maxHeight = jsonN.get("maxHeight").asInt();
        this.maxSize = jsonN.get("maxSize").asInt();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int max) throws WrongArgumentException {
        if (max <= 0) {
            throw new WrongArgumentException("Maximum size must be positive number");
        }
        this.maxSize = max;
    }

    public void setMaxWidth(int maxWidth) throws WrongArgumentException {
        if (maxWidth <= 0) {
            throw new WrongArgumentException("Maximum width must be positive number");
        }
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) throws WrongArgumentException {
        if (maxHeight <= 0) {
            throw new WrongArgumentException("Maximum height must be positive number");
        }
        this.maxHeight = maxHeight;
    }

    public int hashCode() {
        return Objects.hash(this.maxWidth, this.maxHeight, this.maxSize);
    }

    public boolean equals(Object object) {
        if (object instanceof ImageConfiguration) {
            ImageConfiguration that = (ImageConfiguration)object;
            return this.maxWidth == that.maxWidth && this.maxHeight == that.maxHeight && this.maxSize == that.maxSize;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxWidth", this.maxWidth).add("maxHeight", this.maxHeight).add("maxSize", this.maxSize).toString();
    }
}

