/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.stdext.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import pl.edu.icm.unity.base.attribute.IllegalAttributeValueException;
import pl.edu.icm.unity.base.attribute.image.UnityImage;
import pl.edu.icm.unity.stdext.utils.ImageConfiguration;

public final class ImageValidatorUtil {
    public static void validate(ImageConfiguration config, UnityImage value) throws IllegalAttributeValueException {
        if (value == null) {
            throw new IllegalAttributeValueException("null value is illegal");
        }
        if (value.getWidth() > config.getMaxWidth()) {
            throw new IllegalAttributeValueException("Image width (" + value.getWidth() + ") is too big, must be not greater than " + config.getMaxWidth());
        }
        if (value.getHeight() > config.getMaxHeight()) {
            throw new IllegalAttributeValueException("Image height (" + value.getHeight() + ") is too big, must be not greater than " + config.getMaxHeight());
        }
        DiscardOutputStream dos = new DiscardOutputStream();
        String ext = value.getType().toExt();
        try {
            BufferedImage bufferedImage = value.getBufferedImage();
            ImageIO.write((RenderedImage)bufferedImage, ext, dos);
        }
        catch (IOException e) {
            throw new IllegalAttributeValueException("Image can not be encoded as " + ext, (Throwable)e);
        }
        if (dos.getSize() > config.getMaxSize()) {
            throw new IllegalAttributeValueException("Image size after " + ext + " compression (" + dos.getSize() + ") is too big, must be not greater than " + config.getMaxSize());
        }
    }

    private ImageValidatorUtil() {
    }

    private static class DiscardOutputStream
    extends OutputStream {
        private int size = 0;

        private DiscardOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.size += len;
        }

        public int getSize() {
            return this.size;
        }
    }
}

