/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import picocli.CommandLine;

public class Version
implements CommandLine.IVersionProvider {
    public static final String VERSION = Version.doVersion();

    @Override
    public String[] getVersion() {
        return new String[]{VERSION};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doVersion() {
        try {
            URL url = URI.create("http://search.maven.org/solrsearch/select?q=+g:io.jooby+a:jooby&start=0&rows=1").toURL();
            URLConnection connection = url.openConnection();
            try (InputStream in = connection.getInputStream();){
                JSONObject json = new JSONObject(new JSONTokener(in));
                JSONObject response = json.getJSONObject("response");
                JSONArray docs = response.getJSONArray("docs");
                JSONObject jooby = docs.getJSONObject(0);
                String string = jooby.getString("latestVersion");
                return string;
            }
        }
        catch (Exception x) {
            return Optional.ofNullable(Version.class.getPackage()).map(Package::getImplementationVersion).filter(Objects::nonNull).orElse("2.0.6");
        }
    }
}

