/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.cli;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.cli.Cli;
import io.jooby.cli.CliContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.reader.LineReader;

public class CommandContextImpl
implements CliContext {
    private final LineReader reader;
    private final Handlebars templates;
    private final PrintWriter out;
    private final String version;
    private Map configuration;
    private Properties versions;
    private Path configurationFile;

    public CommandContextImpl(LineReader reader, String version) throws IOException {
        this.reader = reader;
        this.out = reader.getTerminal().writer();
        ClassPathTemplateLoader loader = new ClassPathTemplateLoader("/cli");
        this.templates = new Handlebars((TemplateLoader)loader);
        this.templates.setPrettyPrint(true);
        this.version = version;
        this.configurationFile = Paths.get(System.getProperty("user.home"), ".config", "jooby.conf");
        this.migrateOldConfiguration(Paths.get(System.getProperty("user.home"), ".jooby"), this.configurationFile);
        if (Files.exists(this.configurationFile, new LinkOption[0])) {
            try (BufferedReader in = Files.newBufferedReader(this.configurationFile);){
                this.configuration = (Map)Cli.gson.fromJson((Reader)in, LinkedHashMap.class);
            }
        } else {
            this.configuration = new LinkedHashMap();
        }
    }

    private void migrateOldConfiguration(Path from, Path to) throws IOException {
        if (Files.exists(from, new LinkOption[0])) {
            if (!Files.exists(to.getParent(), new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
            }
            Files.copy(from, to, new CopyOption[0]);
            Files.delete(from);
        }
    }

    @Override
    @NonNull
    public String getVersion() {
        return this.configuration.getOrDefault("version", this.version);
    }

    @Override
    @NonNull
    public Path getWorkspace() {
        String workspace = this.configuration.getOrDefault("workspace", System.getProperty("user.dir"));
        return Paths.get(workspace, new String[0]);
    }

    @Override
    public void setWorkspace(@NonNull Path workspace) throws IOException {
        if (!Files.isDirectory(workspace, new LinkOption[0])) {
            throw new FileNotFoundException(workspace.toAbsolutePath().toString());
        }
        this.configuration.put("workspace", workspace.toAbsolutePath().toString());
        String json = Cli.gson.toJson((Object)this.configuration);
        Files.write(this.configurationFile, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public void exit(int code) {
        System.exit(code);
    }

    @Override
    public String readLine(String prompt) {
        return this.reader.readLine(prompt);
    }

    @Override
    public void println(String message) {
        this.out.println(message);
    }

    @Override
    public void writeTemplate(String template, Object model, Path file) throws IOException {
        Path parent = file.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            this.writeTemplate(template, model, writer);
        }
    }

    private void writeTemplate(String template, Object model, Writer writer) throws IOException {
        this.templates.compile(template).apply(model, writer);
    }

    @Override
    public void copyResource(String source, Path dest) throws IOException {
        this.copyResource(source, dest, Collections.emptySet());
    }

    @Override
    public void copyResource(String source, Path dest, Set<PosixFilePermission> permissions) throws IOException {
        Path parent = dest.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (InputStream in = this.getClass().getResourceAsStream(source);){
            Files.copy(in, dest, new CopyOption[0]);
        }
        if (permissions.size() > 0) {
            try {
                Files.setPosixFilePermissions(dest, permissions);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, String> getDependencyMap() throws IOException {
        if (this.versions == null) {
            this.versions = new Properties();
            try (InputStream in = this.getClass().getResourceAsStream("/dependencies.properties");){
                this.versions.load(in);
            }
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.versions.entrySet()) {
            Object key = Stream.of(entry.getKey().toString().split("\\.|-")).map(name -> Character.toUpperCase(name.charAt(0)) + name.substring(1)).collect(Collectors.joining());
            key = Character.toLowerCase(((String)key).charAt(0)) + ((String)key).substring(1);
            result.put((String)key, entry.getValue().toString());
        }
        return result;
    }

    public String toString() {
        return "version: " + this.getVersion() + "; conf: " + String.valueOf(this.configurationFile);
    }
}

