/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.Context;
import io.jooby.Router;
import io.jooby.Session;
import io.jooby.annotation.ContextParam;
import io.jooby.annotation.CookieParam;
import io.jooby.annotation.FormParam;
import io.jooby.annotation.GET;
import io.jooby.annotation.HeaderParam;
import io.jooby.annotation.Path;
import io.jooby.annotation.QueryParam;
import io.jooby.internal.openapi.ASMType;
import io.jooby.internal.openapi.AsmUtils;
import io.jooby.internal.openapi.InsnSupport;
import io.jooby.internal.openapi.OperationExt;
import io.jooby.internal.openapi.ParameterExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.ResponseExt;
import io.jooby.internal.openapi.RoutePath;
import io.jooby.internal.openapi.Signature;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.AnnotationNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.FieldInsnNode;
import io.jooby.internal.openapi.asm.tree.LdcInsnNode;
import io.jooby.internal.openapi.asm.tree.LocalVariableNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.jooby.internal.openapi.asm.tree.ParameterNode;
import io.jooby.internal.openapi.asm.tree.VarInsnNode;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnnotationParser {
    static final String PACKAGE = GET.class.getPackage().getName();
    static final Set<String> IGNORED_PARAM_TYPE = Set.of(Context.class.getName(), Session.class.getName(), "java.util.Optional<" + Session.class.getName() + ">", "kotlin.coroutines.Continuation");
    static final Set<String> IGNORED_ANNOTATIONS = Set.of(ContextParam.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<OperationExt> parse(ParserContext ctx, String prefix, Signature signature, MethodInsnNode node) {
        if (signature.matches(Class.class) || signature.matches(Class.class, Provider.class) || signature.matches(TypeFactory.KT_KLASS) || signature.matches(TypeFactory.KT_KLASS, TypeFactory.KT_FUN_0)) {
            Type type = InsnSupport.prev(node).filter(e -> e instanceof LdcInsnNode && ((LdcInsnNode)e).cst instanceof Type).findFirst().map(e -> (Type)((LdcInsnNode)e).cst).orElseThrow(() -> new IllegalStateException("Mvc class not found: " + InsnSupport.toString(node)));
            return AnnotationParser.parse(ctx, prefix, type);
        }
        if (!signature.matches(TypeFactory.MVC_EXTENSION) && !signature.matches(Object.class)) return Collections.emptyList();
        AbstractInsnNode previous = node.getPrevious();
        if (previous instanceof MethodInsnNode) {
            Type type;
            MethodInsnNode methodInsnNode = (MethodInsnNode)previous;
            if (methodInsnNode.getOpcode() == 183) {
                Type type2 = Type.getObjectType(methodInsnNode.owner);
                ClassNode classNode = ctx.classNode(type2);
                Type controllerType = Optional.ofNullable(classNode.visibleAnnotations).orElse(Collections.emptyList()).stream().filter(it -> TypeFactory.GENERATED.getDescriptor().equals(it.desc)).map(it -> (Type)it.values.get(1)).findFirst().orElse(type2);
                return AnnotationParser.parse(ctx, prefix, controllerType);
            }
            if (methodInsnNode.getOpcode() == 185) {
                AbstractInsnNode methodPrev = methodInsnNode.getPrevious();
                if (methodPrev instanceof VarInsnNode) {
                    Type type3 = Type.getReturnType(methodInsnNode.desc);
                    return AnnotationParser.parse(ctx, prefix, type3);
                }
                if (!(methodPrev instanceof LdcInsnNode)) return Collections.emptyList();
                LdcInsnNode ldcInsnNode = (LdcInsnNode)methodPrev;
                Type type4 = (Type)ldcInsnNode.cst;
                return AnnotationParser.parse(ctx, prefix, type4);
            }
            AbstractInsnNode ldcInsnNode = methodInsnNode.getPrevious();
            if (ldcInsnNode instanceof LdcInsnNode) {
                LdcInsnNode ldcInsnNode2 = (LdcInsnNode)ldcInsnNode;
                type = (Type)ldcInsnNode2.cst;
                return AnnotationParser.parse(ctx, prefix, type);
            }
            type = Type.getReturnType(methodInsnNode.desc);
            return AnnotationParser.parse(ctx, prefix, type);
        }
        if (!(previous instanceof FieldInsnNode)) return Collections.emptyList();
        FieldInsnNode fieldInsnNode = (FieldInsnNode)previous;
        Type type = Type.getObjectType(fieldInsnNode.owner);
        return AnnotationParser.parse(ctx, prefix, type);
    }

    public static List<OperationExt> parse(ParserContext ctx, String prefix, Type type) {
        ArrayList<OperationExt> result = new ArrayList<OperationExt>();
        ClassNode classNode = ctx.classNode(type);
        Collection<MethodNode> methods = AnnotationParser.methods(ctx, classNode).values();
        for (MethodNode method : methods) {
            ctx.debugHandler(method);
            result.addAll(AnnotationParser.routerMethod(ctx, prefix, classNode, method));
        }
        result.forEach(it -> it.setController(classNode));
        return result;
    }

    private static Map<String, MethodNode> methods(ParserContext ctx, ClassNode node) {
        LinkedHashMap<String, MethodNode> methods = new LinkedHashMap<String, MethodNode>();
        if (node.superName != null && !node.superName.equals(TypeFactory.OBJECT.getInternalName())) {
            methods.putAll(AnnotationParser.methods(ctx, ctx.classNode(Type.getObjectType(node.superName))));
        }
        node.methods.stream().filter(AnnotationParser::isRouter).forEach(it -> {
            String signature = it.name + it.desc.substring(0, it.desc.indexOf(41) + 1);
            methods.put(signature, (MethodNode)it);
        });
        return methods;
    }

    private static List<OperationExt> routerMethod(ParserContext ctx, String prefix, ClassNode classNode, MethodNode method) {
        AtomicReference requestBody = new AtomicReference();
        List<ParameterExt> arguments = AnnotationParser.routerArguments(ctx, method, requestBody::set);
        ResponseExt response = AnnotationParser.returnTypes(method);
        ArrayList<OperationExt> result = new ArrayList<OperationExt>();
        for (String httpMethod : AnnotationParser.httpMethod(method.visibleAnnotations)) {
            for (String pattern : AnnotationParser.httpPattern(ctx, classNode, method, httpMethod)) {
                OperationExt operation = new OperationExt(method, httpMethod, RoutePath.path(prefix, pattern), arguments, response);
                operation.setOperationId(method.name);
                Optional.ofNullable((RequestBodyExt)((Object)requestBody.get())).ifPresent(arg_0 -> ((OperationExt)operation).setRequestBody(arg_0));
                result.add(operation);
            }
        }
        return result;
    }

    private static ResponseExt returnTypes(MethodNode method) {
        int i;
        Signature signature = Signature.create(method);
        String desc = Optional.ofNullable(method.signature).orElse(method.desc);
        String continuationType = "Lkotlin/coroutines/Continuation;";
        if (signature.matches(Type.getType(continuationType)) && method.signature != null) {
            desc = method.signature.substring(1, method.signature.indexOf(41));
            desc = desc.substring(continuationType.length() + 1, desc.length() - 2);
        }
        if ((i = desc.indexOf(41)) > 0) {
            desc = desc.substring(i + 1);
        }
        ResponseExt rrt = new ResponseExt();
        rrt.setJavaTypes(Collections.singletonList(ASMType.parse(desc)));
        return rrt;
    }

    private static List<ParameterExt> routerArguments(ParserContext ctx, MethodNode method, Consumer<RequestBodyExt> requestBody) {
        ArrayList<ParameterExt> result = new ArrayList<ParameterExt>();
        LinkedHashMap<String, Schema> form = new LinkedHashMap<String, Schema>();
        ArrayList<String> requiredFormFields = new ArrayList<String>();
        if (method.parameters != null) {
            for (int i = 0; i < method.parameters.size(); ++i) {
                boolean required;
                List<AnnotationNode> annotations;
                String javaType;
                ParameterNode parameter = method.parameters.get(i);
                List<String> javaName = (parameter.name.equals("continuation") || parameter.name.equals("$completion")) && i == method.parameters.size() - 1 ? Arrays.asList(parameter.name, "$continuation") : Collections.singletonList(parameter.name);
                LocalVariableNode variable = method.localVariables.stream().filter(var -> javaName.contains(var.name)).findFirst().orElseThrow(() -> new IllegalStateException("Parameter type not found on method: " + method.name + ", parameter: " + parameter.name));
                String string = javaType = variable.signature == null ? ASMType.parse(variable.desc) : ASMType.parse(variable.signature);
                if (IGNORED_PARAM_TYPE.contains(javaType) || (annotations = method.visibleParameterAnnotations != null && i < method.visibleParameterAnnotations.length ? method.visibleParameterAnnotations[i] : Collections.emptyList()) != null && annotations.stream().anyMatch(n -> IGNORED_ANNOTATIONS.contains(ASMType.parse(n.desc)))) continue;
                ParamType paramType = ParamType.find(annotations);
                boolean bl = required = AnnotationParser.isPrimitive(javaType) || !AnnotationParser.isNullable(method, i);
                if (paramType == ParamType.BODY) {
                    RequestBodyExt body = new RequestBodyExt();
                    body.setRequired(required);
                    body.setJavaType(javaType);
                    requestBody.accept(body);
                    continue;
                }
                if (paramType == ParamType.FORM) {
                    String field = paramType.getHttpName(annotations).orElse(parameter.name);
                    if (required) {
                        requiredFormFields.add(field);
                    }
                    Schema schemaProperty = ctx.schema(javaType);
                    if (ctx.schemaRef(javaType).isPresent()) {
                        RequestBodyExt body = new RequestBodyExt();
                        body.setContentType("multipart/form-data");
                        if (required) {
                            body.setRequired(true);
                        }
                        body.setJavaType(javaType);
                        requestBody.accept(body);
                        continue;
                    }
                    form.put(field, schemaProperty);
                    continue;
                }
                ParameterExt argument = new ParameterExt();
                argument.setName(paramType.getHttpName(annotations).orElse(parameter.name));
                argument.setJavaType(javaType);
                paramType.setIn(argument);
                if (required) {
                    argument.setRequired(true);
                }
                result.add(argument);
            }
        }
        if (form.size() > 0) {
            ObjectSchema schema = new ObjectSchema();
            schema.setProperties(form);
            if (requiredFormFields.size() > 0) {
                schema.setRequired(requiredFormFields);
            }
            MediaType mediaType = new MediaType();
            mediaType.setSchema((Schema)schema);
            Content content = new Content();
            content.addMediaType("multipart/form-data", mediaType);
            RequestBodyExt body = new RequestBodyExt();
            body.setContent(content);
            requestBody.accept(body);
        }
        return result;
    }

    private static boolean isNullable(MethodNode method, int paramIndex) {
        List<AnnotationNode> annotations;
        if (paramIndex < method.invisibleAnnotableParameterCount && (annotations = method.invisibleParameterAnnotations[paramIndex]) != null) {
            return annotations.stream().anyMatch(a -> a.desc.equals("Lorg/jetbrains/annotations/Nullable;"));
        }
        return true;
    }

    private static boolean isPrimitive(String javaType) {
        switch (javaType) {
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "float": 
            case "double": 
            case "long": {
                return true;
            }
        }
        return false;
    }

    private static List<String> httpPattern(ParserContext ctx, ClassNode classNode, MethodNode method, String httpMethod) {
        ArrayList<String> patterns = new ArrayList<String>();
        List<String> rootPattern = AnnotationParser.httpPattern(httpMethod, null, classNode.visibleAnnotations);
        while (rootPattern.isEmpty() && classNode.superName != null) {
            classNode = ctx.classNode(Type.getObjectType(classNode.superName));
            rootPattern = AnnotationParser.httpPattern(httpMethod, null, classNode.visibleAnnotations);
        }
        if (rootPattern.isEmpty()) {
            rootPattern = Collections.singletonList("/");
        }
        for (String prefix : rootPattern) {
            patterns.addAll(AnnotationParser.httpPattern(httpMethod, prefix, method.visibleAnnotations));
        }
        if (patterns.size() == 0) {
            patterns.add("/");
        }
        return patterns;
    }

    private static List<String> httpPattern(String httpMethod, String prefix, List<AnnotationNode> annotations) {
        ArrayList<String> patterns = new ArrayList<String>();
        if (annotations != null) {
            List values = AsmUtils.findAnnotationByType(annotations, Collections.singletonList(PACKAGE + "." + httpMethod)).stream().flatMap(annotation -> Stream.of(annotation).map(AsmUtils::toMap)).filter(m -> !m.isEmpty()).collect(Collectors.toList());
            if (values.isEmpty() && (values = AsmUtils.findAnnotationByType(annotations, Collections.singletonList(Path.class.getName())).stream().flatMap(annotation -> Stream.of(annotation).map(AsmUtils::toMap)).filter(m -> !m.isEmpty()).collect(Collectors.toList())).isEmpty()) {
                values = AsmUtils.findAnnotationByType(annotations, Collections.singletonList(jakarta.ws.rs.Path.class.getName())).stream().flatMap(annotation -> Stream.of(annotation).map(AsmUtils::toMap)).filter(m -> !m.isEmpty()).collect(Collectors.toList());
            }
            for (Map map : values) {
                List<Object> value = map.getOrDefault("value", Collections.emptyList());
                if (!(value instanceof Collection)) {
                    value = Collections.singletonList(value);
                }
                value.forEach(v -> patterns.add(RoutePath.path(prefix, v.toString())));
            }
        }
        if (prefix != null && patterns.isEmpty()) {
            patterns.add(RoutePath.path(prefix, null));
        }
        return patterns;
    }

    private static List<String> httpMethod(List<AnnotationNode> annotations) {
        List<String> methods = AsmUtils.findAnnotationByType(annotations, AnnotationParser.httpMethods()).stream().map(n -> Type.getType(n.desc).getClassName()).map(name -> {
            String[] names = name.split("\\.");
            return names[names.length - 1];
        }).distinct().collect(Collectors.toList());
        if (methods.size() == 1 && methods.contains("Path")) {
            return Collections.singletonList("GET");
        }
        methods.remove("Path");
        return methods;
    }

    private static boolean isRouter(MethodNode node) {
        if (node.visibleAnnotations != null) {
            List annotationTypes = AnnotationParser.httpMethods().stream().map(classname -> Type.getObjectType(classname.replace(".", "/")).getDescriptor()).collect(Collectors.toList());
            return node.visibleAnnotations.stream().anyMatch(a -> annotationTypes.contains(a.desc));
        }
        return false;
    }

    private static List<String> httpMethods() {
        List<String> annotationTypes = AnnotationParser.httpMethod(GET.class.getPackage().getName(), Path.class);
        annotationTypes.addAll(AnnotationParser.httpMethod(jakarta.ws.rs.GET.class.getPackage().getName(), jakarta.ws.rs.Path.class));
        return annotationTypes;
    }

    private static List<String> httpMethod(String pkg, Class pathType) {
        List<String> annotationTypes = Router.METHODS.stream().map(m -> pkg + "." + m).collect(Collectors.toList());
        if (pathType != null) {
            annotationTypes.add(Type.getType(pathType).getClassName());
        }
        return annotationTypes;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ParamType {
        CONTEXT{

            @Override
            public Class[] annotations() {
                return new Class[]{ContextParam.class};
            }
        }
        ,
        HEADER{

            @Override
            public Class[] annotations() {
                return new Class[]{HeaderParam.class, jakarta.ws.rs.HeaderParam.class};
            }

            @Override
            public void setIn(Parameter parameter) {
                parameter.setIn("header");
            }
        }
        ,
        COOKIE{

            @Override
            public Class[] annotations() {
                return new Class[]{CookieParam.class, jakarta.ws.rs.CookieParam.class};
            }

            @Override
            public void setIn(Parameter parameter) {
                parameter.setIn("cookie");
            }
        }
        ,
        PATH{

            @Override
            public Class[] annotations() {
                return new Class[]{io.jooby.annotation.PathParam.class, PathParam.class};
            }

            @Override
            public void setIn(Parameter parameter) {
                parameter.setIn("path");
                parameter.setRequired(Boolean.valueOf(true));
            }
        }
        ,
        QUERY{

            @Override
            public Class[] annotations() {
                return new Class[]{QueryParam.class, jakarta.ws.rs.QueryParam.class};
            }

            @Override
            public void setIn(Parameter parameter) {
                parameter.setIn("query");
            }
        }
        ,
        FORM{

            @Override
            public Class[] annotations() {
                return new Class[]{FormParam.class, jakarta.ws.rs.FormParam.class};
            }

            @Override
            public void setIn(Parameter parameter) {
                parameter.setIn("form");
            }
        }
        ,
        BODY{

            @Override
            public Class[] annotations() {
                return new Class[0];
            }
        };


        public abstract Class[] annotations();

        public boolean matches(String annotationType) {
            return Stream.of(this.annotations()).anyMatch(t -> t.getName().equals(annotationType));
        }

        public void setIn(Parameter parameter) {
        }

        public Optional<String> getHttpName(List<AnnotationNode> annotations) {
            ArrayList<Class> names = new ArrayList<Class>(Arrays.asList(this.annotations()));
            names.add(Named.class);
            return annotations.stream().filter(a -> names.stream().anyMatch(c -> Type.getDescriptor(c).equals(a.desc))).map(a -> {
                if (a.values != null) {
                    for (int i = 0; i < a.values.size(); ++i) {
                        Object value;
                        if (!a.values.get(i).equals("value") || (value = a.values.get(i + 1)) == null || value.toString().trim().length() <= 0) continue;
                        return value.toString().trim();
                    }
                }
                return null;
            }).filter(Objects::nonNull).findFirst();
        }

        public static ParamType find(List<AnnotationNode> annotations) {
            if (annotations != null) {
                for (AnnotationNode annotation : annotations) {
                    String annotationType = Type.getType(annotation.desc).getClassName();
                    for (ParamType paramType : ParamType.values()) {
                        if (!paramType.matches(annotationType)) continue;
                        return paramType;
                    }
                }
            }
            return BODY;
        }
    }
}

