/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jooby.internal.openapi.MergePolicy;
import io.jooby.internal.openapi.OperationExt;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class OpenAPIExt
extends OpenAPI {
    @JsonIgnore
    private List<OperationExt> operations = Collections.emptyList();
    @JsonIgnore
    private String source;

    public List<OperationExt> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationExt> operations) {
        this.operations = operations;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String classname) {
        this.source = classname;
    }

    public void setPaths(Paths paths) {
        Paths existingPaths = this.getPaths();
        if (existingPaths != null && !existingPaths.isEmpty()) {
            MergePolicy mergePolicy = MergePolicy.parse(existingPaths.getExtensions(), MergePolicy.parse(this.getExtensions(), MergePolicy.IGNORE));
            super.setPaths(this.mergePaths(existingPaths, paths, mergePolicy));
        } else {
            super.setPaths(paths);
        }
    }

    private Paths mergePaths(Paths docPaths, Paths paths, MergePolicy mergePolicy) {
        for (Map.Entry e : docPaths.entrySet()) {
            String pattern = (String)e.getKey();
            PathItem path = (PathItem)paths.get((Object)pattern);
            if (path != null) {
                PathItem docPath = (PathItem)e.getValue();
                this.setProperty(docPath, PathItem::getSummary, path, PathItem::setSummary);
                this.setProperty(docPath, PathItem::getDescription, path, PathItem::setDescription);
                this.setProperty(docPath, PathItem::getServers, path, PathItem::setServers);
                this.setProperty(docPath, PathItem::getParameters, path, PathItem::setParameters);
                this.setProperty(docPath, PathItem::get$ref, path, PathItem::set$ref);
                this.setProperty(docPath, PathItem::getExtensions, path, PathItem::setExtensions);
                this.mergeOperation("GET", pattern, docPath.getGet(), path.getGet(), mergePolicy, arg_0 -> ((PathItem)path).setGet(arg_0));
                this.mergeOperation("POST", pattern, docPath.getPost(), path.getPost(), mergePolicy, arg_0 -> ((PathItem)path).setPost(arg_0));
                this.mergeOperation("PUT", pattern, docPath.getPut(), path.getPut(), mergePolicy, arg_0 -> ((PathItem)path).setPut(arg_0));
                this.mergeOperation("PATCH", pattern, docPath.getPatch(), path.getPatch(), mergePolicy, arg_0 -> ((PathItem)path).setPatch(arg_0));
                this.mergeOperation("DELETE", pattern, docPath.getDelete(), path.getDelete(), mergePolicy, arg_0 -> ((PathItem)path).setDelete(arg_0));
                this.mergeOperation("HEAD", pattern, docPath.getHead(), path.getHead(), mergePolicy, arg_0 -> ((PathItem)path).setHead(arg_0));
                this.mergeOperation("OPTIONS", pattern, docPath.getOptions(), path.getOptions(), mergePolicy, arg_0 -> ((PathItem)path).setOptions(arg_0));
                this.mergeOperation("TRACE", pattern, docPath.getTrace(), path.getTrace(), mergePolicy, arg_0 -> ((PathItem)path).setTrace(arg_0));
                continue;
            }
            if (!mergePolicy.handle("Unknown path: \"" + pattern + "\"")) continue;
            PathItem newOperation = (PathItem)e.getValue();
            this.clearMergePolicy(newOperation, PathItem::getExtensions, PathItem::setExtensions);
            this.clearMergePolicy(newOperation.getGet(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getPost(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getPut(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getPatch(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getDelete(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getHead(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getOptions(), Operation::getExtensions, Operation::setExtensions);
            this.clearMergePolicy(newOperation.getTrace(), Operation::getExtensions, Operation::setExtensions);
            paths.put((Object)((String)e.getKey()), (Object)newOperation);
        }
        return paths;
    }

    private <T> void clearMergePolicy(T src, Function<T, Map<String, Object>> getter, BiConsumer<T, Map<String, Object>> setter) {
        Map<String, Object> extensions;
        if (src != null && (extensions = getter.apply(src)) != null) {
            extensions.remove("x-merge-policy");
            if (extensions.isEmpty()) {
                extensions = null;
            }
            setter.accept(src, extensions);
        }
    }

    private void mergeOperation(String method, String pattern, Operation src, Operation target, MergePolicy defaultMergePolicy, Consumer<Operation> appender) {
        if (src != null) {
            MergePolicy mergePolicy = MergePolicy.parse(src.getExtensions(), defaultMergePolicy);
            if (target != null) {
                this.setProperty(src, Operation::getTags, target, Operation::setTags);
                this.setProperty(src, Operation::getSummary, target, Operation::setSummary);
                this.setProperty(src, Operation::getDescription, target, Operation::setDescription);
                this.setProperty(src, Operation::getExternalDocs, target, Operation::setExternalDocs);
                this.setProperty(src, Operation::getOperationId, target, Operation::setOperationId);
                this.setProperty(src, Operation::getRequestBody, target, Operation::setRequestBody);
                this.setProperty(src, Operation::getResponses, target, Operation::setResponses);
                this.setProperty(src, Operation::getCallbacks, target, Operation::setCallbacks);
                this.setProperty(src, Operation::getDeprecated, target, Operation::setDeprecated);
                this.setProperty(src, Operation::getSecurity, target, Operation::setSecurity);
                this.setProperty(src, Operation::getServers, target, Operation::setServers);
                this.setProperty(src, Operation::getExtensions, target, Operation::setExtensions);
                List<Parameter> srcParameters = Optional.ofNullable(src.getParameters()).orElseGet(List::of).stream().filter(Objects::nonNull).toList();
                List<Parameter> targetParameters = Optional.ofNullable(target.getParameters()).orElseGet(List::of).stream().filter(Objects::nonNull).toList();
                for (Parameter srcParameter : srcParameters) {
                    targetParameters.stream().filter(it -> it.getName().equals(srcParameter.getName())).findFirst().ifPresent(targetParameter -> this.mergeParameter(srcParameter, (Parameter)targetParameter));
                }
            } else if (mergePolicy.handle("Operation not found: " + method + " " + pattern)) {
                appender.accept(src);
            }
        }
    }

    private void mergeParameter(Parameter src, Parameter target) {
        this.setProperty(src, Parameter::getIn, target, Parameter::setIn);
        this.setProperty(src, Parameter::getDescription, target, Parameter::setDescription);
        this.setProperty(src, Parameter::getRequired, target, Parameter::setRequired);
        this.setProperty(src, Parameter::getDeprecated, target, Parameter::setDeprecated);
        this.setProperty(src, Parameter::getAllowEmptyValue, target, Parameter::setAllowEmptyValue);
        this.setProperty(src, Parameter::get$ref, target, Parameter::set$ref);
        this.setProperty(src, Parameter::getStyle, target, Parameter::setStyle);
        this.setProperty(src, Parameter::getExplode, target, Parameter::setExplode);
        this.setProperty(src, Parameter::getAllowReserved, target, Parameter::setAllowReserved);
        this.setProperty(src, Parameter::getSchema, target, Parameter::setSchema);
        this.setProperty(src, Parameter::getExamples, target, Parameter::setExamples);
        this.setProperty(src, Parameter::getExample, target, Parameter::setExample);
        this.setProperty(src, Parameter::getContent, target, Parameter::setContent);
        this.setProperty(src, Parameter::getExtensions, target, Parameter::setExtensions);
    }

    private <S, V> void setProperty(S src, Function<S, V> getter, S target, BiConsumer<S, V> setter) {
        V value = getter.apply(src);
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (!collection.isEmpty()) {
                    setter.accept(target, value);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                if (!map.isEmpty()) {
                    setter.accept(target, value);
                }
            } else if (value instanceof CharSequence) {
                CharSequence string = (CharSequence)value;
                if (!string.isEmpty()) {
                    setter.accept(target, value);
                }
            } else {
                setter.accept(target, value);
            }
        }
    }
}

