/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.vertx.sqlclient;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Reified;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.internal.vertx.sqlclient.VertxPreparedQueryProxy;
import io.jooby.internal.vertx.sqlclient.VertxPreparedQueryProxyList;
import io.jooby.internal.vertx.sqlclient.VertxPreparedStatementProxy;
import io.jooby.internal.vertx.sqlclient.VertxPreparedStatementProxyList;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnectOptions;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public abstract class VertxSqlConnectionModule
implements Extension {
    private static final Reified<PreparedQuery<RowSet<Row>>> PreparedQueryType = Reified.getParameterized(PreparedQuery.class, (Type[])new Type[]{Reified.getParameterized(RowSet.class, (Type[])new Type[]{Row.class}).getType()});
    private static final Reified<List<PreparedQuery<RowSet<Row>>>> PreparedQueryTypeList = Reified.list((Type)PreparedQueryType.getType());
    private Map<String, List<String>> preparedStatements = Map.of();
    private final String name;

    public VertxSqlConnectionModule(String name) {
        this.name = name;
    }

    public VertxSqlConnectionModule() {
        this("db");
    }

    public VertxSqlConnectionModule prepare(@NonNull Map<String, List<String>> statements) {
        this.preparedStatements = statements;
        return this;
    }

    public final void install(@NonNull Jooby application) throws Exception {
        ServiceRegistry registry = application.getServices();
        Config config = application.getConfig();
        ConfigValue configOptions = config.getValue(this.name);
        SqlConnectOptions connectOptions = configOptions.valueType() == ConfigValueType.STRING ? this.fromUri(config.getString(this.name)) : this.fromMap(new JsonObject(config.getObject(this.name).unwrapped()));
        for (String name : this.preparedStatements.keySet()) {
            registry.put(ServiceKey.key((Reified)Reified.list(PreparedStatement.class), (String)name), (Object)new VertxPreparedStatementProxyList(name));
            registry.put(ServiceKey.key(PreparedStatement.class, (String)name), (Object)new VertxPreparedStatementProxy(name));
            registry.put(ServiceKey.key(PreparedQueryTypeList, (String)name), (Object)new VertxPreparedQueryProxyList(name + ".query"));
            registry.put(ServiceKey.key(PreparedQueryType, (String)name), (Object)new VertxPreparedQueryProxy(name + ".query"));
        }
        Vertx vertx = (Vertx)registry.require(Vertx.class);
        DeploymentOptions options = new DeploymentOptions().setInstances(application.getServerOptions().getIoThreads());
        Future connection = vertx.deployVerticle(() -> this.newSqlClient(connectOptions, this.preparedStatements), options);
        this.install(application, this.name, connectOptions);
        connection.await();
    }

    protected abstract void install(Jooby var1, String var2, SqlConnectOptions var3);

    protected abstract SqlConnectOptions fromMap(JsonObject var1);

    protected abstract SqlConnectOptions fromUri(String var1);

    protected abstract Deployable newSqlClient(SqlConnectOptions var1, Map<String, List<String>> var2);
}

