/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class XRayErrorCause {
    private final String working_directory = System.getProperty("user.dir");
    private final Collection<XRayException> exceptions;
    private final Collection<String> paths;

    public XRayErrorCause(Throwable throwable) {
        this.exceptions = Collections.unmodifiableCollection(Collections.singletonList(new XRayException(throwable)));
        this.paths = Collections.unmodifiableCollection(Arrays.stream(throwable.getStackTrace()).map(XRayErrorCause::determineFileName).collect(Collectors.toSet()));
    }

    public String getWorking_directory() {
        return this.working_directory;
    }

    public Collection<XRayException> getExceptions() {
        return this.exceptions;
    }

    public Collection<String> getPaths() {
        return this.paths;
    }

    private static String determineFileName(StackTraceElement e) {
        String fileName = null;
        if (e.getFileName() != null) {
            fileName = e.getFileName();
        }
        if (fileName == null) {
            String className = e.getClassName();
            fileName = className == null ? null : className.substring(className.lastIndexOf(46) + 1) + ".java";
        }
        return fileName;
    }

    public static class XRayException {
        private final String message;
        private final String type;
        private final List<StackElement> stack;

        public XRayException(Throwable throwable) {
            this.message = throwable.getMessage();
            this.type = throwable.getClass().getName();
            this.stack = Arrays.stream(throwable.getStackTrace()).map(this::toStackElement).collect(Collectors.toList());
        }

        private StackElement toStackElement(StackTraceElement e) {
            return new StackElement(e.getMethodName(), XRayErrorCause.determineFileName(e), e.getLineNumber());
        }

        public String getMessage() {
            return this.message;
        }

        public String getType() {
            return this.type;
        }

        public List<StackElement> getStack() {
            return this.stack;
        }

        public static class StackElement {
            private final String label;
            private final String path;
            private final int line;

            private StackElement(String label, String path, int line) {
                this.label = label;
                this.path = path;
                this.line = line;
            }

            public String getLabel() {
                return this.label;
            }

            public String getPath() {
                return this.path;
            }

            public int getLine() {
                return this.line;
            }
        }
    }
}

