/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm;

import io.roastedroot.proxywasm.MetricType;
import io.roastedroot.proxywasm.MetricsHandler;
import io.roastedroot.proxywasm.WasmException;
import io.roastedroot.proxywasm.internal.WasmResult;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleMetricsHandler
implements MetricsHandler {
    private final AtomicInteger lastMetricId = new AtomicInteger(0);
    private final HashMap<Integer, Metric> metrics = new HashMap();
    private final HashMap<String, Metric> metricsByName = new HashMap();

    @Override
    public synchronized int defineMetric(MetricType type, String name) throws WasmException {
        int id = this.lastMetricId.incrementAndGet();
        Metric value = new Metric(id, type, name);
        this.metrics.put(id, value);
        this.metricsByName.put(name, value);
        return id;
    }

    @Override
    public synchronized long getMetric(int metricId) throws WasmException {
        Metric metric = this.metrics.get(metricId);
        if (metric == null) {
            throw new WasmException(WasmResult.NOT_FOUND);
        }
        return metric.getValue();
    }

    @Override
    public synchronized WasmResult incrementMetric(int metricId, long value) {
        Metric metric = this.metrics.get(metricId);
        if (metric == null) {
            return WasmResult.NOT_FOUND;
        }
        metric.setValue(metric.getValue() + value);
        return WasmResult.OK;
    }

    @Override
    public synchronized WasmResult recordMetric(int metricId, long value) {
        Metric metric = this.metrics.get(metricId);
        if (metric == null) {
            return WasmResult.NOT_FOUND;
        }
        metric.setValue(value);
        return WasmResult.OK;
    }

    @Override
    public synchronized WasmResult removeMetric(int metricId) {
        Metric metric = this.metrics.remove(metricId);
        if (metric == null) {
            return WasmResult.NOT_FOUND;
        }
        this.metricsByName.remove(metric.name());
        return WasmResult.OK;
    }

    public static class Metric {
        private final int id;
        private final MetricType type;
        private final String name;
        private long value;

        public Metric(int id, MetricType type, String name) {
            this.id = id;
            this.type = type;
            this.name = name;
        }

        public int id() {
            return this.id;
        }

        public MetricType type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }
}

