/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.ProxyMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArrayBytesProxyMap
implements ProxyMap {
    final ArrayList<Map.Entry<String, byte[]>> entries;

    public ArrayBytesProxyMap() {
        this.entries = new ArrayList();
    }

    public ArrayBytesProxyMap(int mapSize) {
        this.entries = new ArrayList(mapSize);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void add(String key, String value) {
        this.entries.add(Map.entry(key, Helpers.bytes(value)));
    }

    public void add(String key, byte[] value) {
        this.entries.add(Map.entry(key, value));
    }

    @Override
    public void put(String key, String value) {
        this.remove(key);
        this.entries.add(Map.entry(key, Helpers.bytes(value)));
    }

    public void put(String key, byte[] value) {
        this.remove(key);
        this.entries.add(Map.entry(key, value));
    }

    @Override
    public Iterable<? extends Map.Entry<String, String>> entries() {
        return this.entries.stream().map(x -> Map.entry((String)x.getKey(), Helpers.string((byte[])x.getValue()))).collect(Collectors.toList());
    }

    @Override
    public Stream<Map.Entry<byte[], byte[]>> streamBytes() {
        return this.entries.stream().map(x -> Map.entry(Helpers.bytes((String)x.getKey()), (byte[])x.getValue()));
    }

    @Override
    public String get(String key) {
        return this.entries.stream().filter(x -> ((String)x.getKey()).equals(key)).map(Map.Entry::getValue).map(Helpers::string).findFirst().orElse(null);
    }

    @Override
    public void remove(String key) {
        this.entries.removeIf(x -> ((String)x.getKey()).equals(key));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayBytesProxyMap that = (ArrayBytesProxyMap)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hashCode(this.entries);
    }

    public String toString() {
        return this.entries.toString();
    }

    @Override
    public byte[] encode() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream o = new DataOutputStream(baos);
            int mapSize = this.size();
            o.writeInt(mapSize);
            for (Map.Entry<String, byte[]> entry : this.entries) {
                o.writeInt(Helpers.len(entry.getKey()));
                o.writeInt(Helpers.len(entry.getValue()));
            }
            for (Map.Entry<String, byte[]> entry : this.entries) {
                o.write(Helpers.bytes(entry.getKey()));
                o.write(0);
                o.write(entry.getValue());
                o.write(0);
            }
            o.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

