/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.ProxyMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class ArrayProxyMap
implements ProxyMap {
    final ArrayList<Map.Entry<String, String>> entries;

    public ArrayProxyMap() {
        this.entries = new ArrayList();
    }

    public ArrayProxyMap(int mapSize) {
        this.entries = new ArrayList(mapSize);
    }

    public ArrayProxyMap(ProxyMap other) {
        this(other.size());
        for (Map.Entry<String, String> entry : other.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public ArrayProxyMap(Map<String, String> other) {
        this(other.size());
        for (Map.Entry<String, String> entry : other.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void add(String key, String value) {
        this.entries.add(Map.entry(key, value));
    }

    @Override
    public void put(String key, String value) {
        this.remove(key);
        this.entries.add(Map.entry(key, value));
    }

    @Override
    public Iterable<? extends Map.Entry<String, String>> entries() {
        return this.entries;
    }

    @Override
    public String get(String key) {
        return this.entries.stream().filter(x -> ((String)x.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    @Override
    public void remove(String key) {
        this.entries.removeIf(x -> ((String)x.getKey()).equals(key));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayProxyMap that = (ArrayProxyMap)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hashCode(this.entries);
    }

    public String toString() {
        return this.entries.toString();
    }
}

