/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.Action;
import io.roastedroot.proxywasm.internal.Context;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.PeerType;
import io.roastedroot.proxywasm.internal.ProxyWasm;
import io.roastedroot.proxywasm.internal.StreamType;

public class NetworkContext
extends Context {
    private final Handler handler;

    NetworkContext(ProxyWasm proxyWasm, Handler handler) {
        super(proxyWasm);
        this.handler = handler;
    }

    @Override
    Handler handler() {
        return this.handler;
    }

    public Action callOnNewConnection() {
        int result = this.proxyWasm.abi().proxyOnNewConnection(this.id);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.DOWNSTREAM, action);
        return action;
    }

    public Action callOnDownstreamData(boolean endOfStream) {
        byte[] data = this.handler.getDownStreamData();
        int result = this.proxyWasm.abi().proxyOnDownstreamData(this.id, Helpers.len(data), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.DOWNSTREAM, action);
        return action;
    }

    public Action callOnUpstreamData(boolean endOfStream) {
        byte[] data = this.handler.getUpstreamData();
        int result = this.proxyWasm.abi().proxyOnUpstreamData(this.id, Helpers.len(data), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.UPSTREAM, action);
        return action;
    }

    public void callOnDownstreamConnectionClose(PeerType type) {
        this.proxyWasm.abi().proxyOnDownstreamConnectionClose(this.id, type.getValue());
    }

    public void callOnDownstreamConnectionClose() {
        this.callOnDownstreamConnectionClose(PeerType.LOCAL);
    }
}

