/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.PluginFactory;
import io.roastedroot.proxywasm.StartException;
import io.roastedroot.proxywasm.internal.Plugin;
import io.roastedroot.proxywasm.internal.ServerAdaptor;
import java.util.Collection;
import java.util.List;

public interface Pool {
    public Plugin borrow() throws StartException;

    public String name();

    public void release(Plugin var1);

    default public void close() {
    }

    public static class PluginPerRequest
    implements Pool {
        private final ServerAdaptor serverAdaptor;
        final PluginFactory factory;
        private final String name;

        public PluginPerRequest(ServerAdaptor serverAdaptor, PluginFactory factory, Plugin plugin) {
            this.serverAdaptor = serverAdaptor;
            this.factory = factory;
            this.name = plugin.name();
            this.release(plugin);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Plugin borrow() throws StartException {
            Plugin plugin = null;
            try {
                plugin = (Plugin)this.factory.create();
            }
            catch (Throwable e) {
                throw new StartException("Plugin create failed.", e);
            }
            plugin.setServerAdaptor(this.serverAdaptor);
            plugin.wasm.start();
            return plugin;
        }

        @Override
        public void release(Plugin plugin) {
            plugin.close();
        }
    }

    public static class SharedPlugin
    implements Pool {
        private final Plugin plugin;

        public SharedPlugin(ServerAdaptor serverAdaptor, Plugin plugin) throws StartException {
            this.plugin = plugin;
            this.plugin.setServerAdaptor(serverAdaptor);
        }

        @Override
        public void close() {
            this.plugin.wasm.close();
        }

        public Collection<Plugin> getPluginPools() {
            return List.of(this.plugin);
        }

        @Override
        public String name() {
            return this.plugin.name();
        }

        @Override
        public void release(Plugin plugin) {
            if (plugin != this.plugin) {
                throw new IllegalArgumentException("Plugin not from this pool");
            }
        }

        @Override
        public Plugin borrow() throws StartException {
            this.plugin.wasm.start();
            return this.plugin;
        }
    }
}

