/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.ArrayProxyMap;
import io.roastedroot.proxywasm.internal.Helpers;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ProxyMap {
    public static ProxyMap of(String ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("values must be even");
        }
        ArrayProxyMap map = new ArrayProxyMap(values.length / 2);
        for (int i = 0; i < values.length; i += 2) {
            map.add(values[i], values[i + 1]);
        }
        return map;
    }

    public static ProxyMap copyOf(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        return new ArrayProxyMap(headers);
    }

    public int size();

    public void add(String var1, String var2);

    public void put(String var1, String var2);

    public Iterable<? extends Map.Entry<String, String>> entries();

    default public Stream<Map.Entry<byte[], byte[]>> streamBytes() {
        return StreamSupport.stream(this.entries().spliterator(), false).map(x -> Map.entry(Helpers.bytes((String)x.getKey()), Helpers.bytes((String)x.getValue())));
    }

    public String get(String var1);

    public void remove(String var1);

    default public byte[] encode() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream o = new DataOutputStream(baos);
            int mapSize = this.size();
            o.writeInt(mapSize);
            ArrayList<Map.Entry<byte[], byte[]>> entries = new ArrayList<Map.Entry<byte[], byte[]>>(this.size());
            for (Map.Entry<String, String> entry : this.entries()) {
                Map.Entry<byte[], byte[]> encoded = Map.entry(Helpers.bytes(entry.getKey()), Helpers.bytes(entry.getValue()));
                entries.add(encoded);
                o.writeInt(Helpers.len(encoded.getKey()));
                o.writeInt(Helpers.len(encoded.getValue()));
            }
            for (Map.Entry<String, String> entry : entries) {
                o.write((byte[])entry.getKey());
                o.write(0);
                o.write((byte[])entry.getValue());
                o.write(0);
            }
            o.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

