/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.testutils;

import io.simplesource.data.FutureResult;
import io.simplesource.kafka.internal.client.RequestPublisher;
import java.time.Instant;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.test.ConsumerRecordFactory;

class TestPublisher<K, V>
implements RequestPublisher<K, V> {
    private final ConsumerRecordFactory<K, V> factory;
    TopologyTestDriver driver;
    private final String topicName;

    TestPublisher(TopologyTestDriver driver, Serde<K> keySerde, Serde<V> valueSerde, String topicName) {
        this.driver = driver;
        this.topicName = topicName;
        this.factory = new ConsumerRecordFactory(keySerde.serializer(), valueSerde.serializer());
    }

    public FutureResult<Exception, RequestPublisher.PublishResult> publish(K key, V value) {
        this.driver.pipeInput(this.factory.create(this.topicName, key, value));
        return FutureResult.of((Object)new RequestPublisher.PublishResult(Instant.now().getEpochSecond()));
    }
}

