/*
 * Decompiled with CFR 0.152.
 */
package io.split.api;

import io.split.api.SplitApiClientConfig;
import io.split.api.client.HttpClient;
import io.split.api.resources.AttributeClient;
import io.split.api.resources.EnvironmentClient;
import io.split.api.resources.IdentityClient;
import io.split.api.resources.TrafficTypeClient;

public class SplitApiClient {
    private final HttpClient _httpClient;
    private final TrafficTypeClient trafficTypeClient;
    private final EnvironmentClient environmentClient;
    private final AttributeClient attributeClient;
    private final IdentityClient identityClient;

    public static SplitApiClient client(String apiToken) {
        return SplitApiClient.client(apiToken, SplitApiClientConfig.builder().build());
    }

    public static synchronized SplitApiClient client(String apiToken, SplitApiClientConfig config) {
        return new SplitApiClient(apiToken, config);
    }

    private SplitApiClient(String apiToken, SplitApiClientConfig config) {
        this._httpClient = new HttpClient(apiToken, config);
        this.trafficTypeClient = new TrafficTypeClient(this._httpClient);
        this.environmentClient = new EnvironmentClient(this._httpClient);
        this.attributeClient = new AttributeClient(this._httpClient);
        this.identityClient = new IdentityClient(this._httpClient);
    }

    public TrafficTypeClient trafficTypes() {
        return this.trafficTypeClient;
    }

    public EnvironmentClient environments() {
        return this.environmentClient;
    }

    public AttributeClient attributes() {
        return this.attributeClient;
    }

    public IdentityClient identities() {
        return this.identityClient;
    }
}

