/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.githubreleaseapi;

import java.util.ArrayList;
import java.util.List;
import lol.hyper.githubreleaseapi.jetbrains.annotations.NotNull;
import lol.hyper.githubreleaseapi.json.JSONArray;
import lol.hyper.githubreleaseapi.json.JSONObject;

public class GitHubRelease {
    private final JSONObject object;

    protected GitHubRelease(JSONObject object) {
        this.object = object;
    }

    @NotNull
    public String getTagVersion() {
        return this.object.getString("tag_name");
    }

    @NotNull
    public String getReleaseNotes() {
        return this.object.getString("body");
    }

    @NotNull
    public String getPublishedDate() {
        return this.object.getString("published_at");
    }

    @NotNull
    public String getCreatedDate() {
        return this.object.getString("created_at");
    }

    @NotNull
    public List<String> getReleaseAssets() {
        ArrayList<String> urls = new ArrayList<String>();
        JSONArray releases = this.object.getJSONArray("assets");
        for (int i = 0; i < releases.length(); ++i) {
            JSONObject temp = releases.getJSONObject(i);
            urls.add(temp.getString("browser_download_url"));
        }
        return urls;
    }

    public boolean isDraft() {
        return this.object.getBoolean("draft");
    }

    public boolean isPreRelease() {
        return this.object.getBoolean("prerelease");
    }

    public String getRegularLink() {
        return this.object.getString("html_url");
    }
}

