/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.githubreleaseapi;

import java.util.ArrayList;
import java.util.List;
import lol.hyper.githubreleaseapi.jetbrains.annotations.NotNull;
import lol.hyper.githubreleaseapi.json.JSONArray;
import lol.hyper.githubreleaseapi.json.JSONObject;

public class GitHubRelease {
    private final String tagVersion;
    private final String releaseNotes;
    private final String publishedDate;
    private final String creationDate;
    private final List<String> releaseAssets = new ArrayList<String>();
    private final boolean isDraft;
    private final boolean isPreRelease;
    private final String releaseURL;

    protected GitHubRelease(JSONObject object) {
        this.tagVersion = object.getString("tag_name");
        this.releaseNotes = object.getString("body");
        this.publishedDate = object.getString("published_at");
        this.creationDate = object.getString("created_at");
        JSONArray assets = object.getJSONArray("assets");
        for (int i = 0; i < assets.length(); ++i) {
            JSONObject temp = assets.getJSONObject(i);
            this.releaseAssets.add(temp.getString("browser_download_url"));
        }
        this.isDraft = object.getBoolean("draft");
        this.isPreRelease = object.getBoolean("prerelease");
        this.releaseURL = object.getString("html_url");
    }

    @NotNull
    public String getTagVersion() {
        return this.tagVersion;
    }

    @NotNull
    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    @NotNull
    public String getPublishedDate() {
        return this.publishedDate;
    }

    @NotNull
    public String getCreatedDate() {
        return this.creationDate;
    }

    @NotNull
    public List<String> getReleaseAssets() {
        return this.releaseAssets;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public boolean isPreRelease() {
        return this.isPreRelease;
    }

    @Deprecated
    public String getRegularLink() {
        return this.releaseURL;
    }

    public String getReleaseURL() {
        return this.releaseURL;
    }

    public String toString() {
        return this.tagVersion;
    }
}

