/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.githubreleaseapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lol.hyper.githubreleaseapi.GitHubRelease;
import lol.hyper.githubreleaseapi.NoReleasesFoundException;
import lol.hyper.githubreleaseapi.ReleaseNotFoundException;
import lol.hyper.githubreleaseapi.jetbrains.annotations.NotNull;
import lol.hyper.githubreleaseapi.json.JSONArray;

public class GitHubReleaseAPI {
    private JSONArray array;
    private List<GitHubRelease> releases;
    private final String repoURL;
    private final String repositoryName;
    private final String organizationName;

    public GitHubReleaseAPI(@NotNull String repoName, @NotNull String orgName) throws IOException {
        this.array = this.readGitHubAPI(repoName, orgName);
        this.releases = this.getReleases();
        this.repoURL = "https://github.com/" + orgName + "/" + repoName;
        this.organizationName = orgName;
        this.repositoryName = repoName;
    }

    @NotNull
    public List<GitHubRelease> getAllReleases() {
        if (this.releases.isEmpty()) {
            throw new NoReleasesFoundException(this.repoURL);
        }
        return this.releases;
    }

    public int getBuildsBehind(GitHubRelease release) {
        if (this.releases.isEmpty()) {
            throw new NoReleasesFoundException(this.repoURL);
        }
        return this.releases.indexOf(release);
    }

    @NotNull
    public GitHubRelease getLatestVersion() {
        if (this.releases.isEmpty()) {
            throw new NoReleasesFoundException(this.repoURL);
        }
        return this.releases.get(0);
    }

    @NotNull
    public GitHubRelease getReleaseByTag(@NotNull String tag) {
        for (GitHubRelease release : this.releases) {
            if (!release.getTagVersion().equalsIgnoreCase(tag)) continue;
            return release;
        }
        throw new ReleaseNotFoundException(tag);
    }

    @NotNull
    private JSONArray readGitHubAPI(String repoName, String orgName) throws IOException {
        URL url = new URL("https://api.github.com/repos/" + orgName + "/" + repoName + "/releases");
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", "GitHubReleaseAPI https://github.com/hyperdefined/GitHubReleaseAPI");
        conn.setRequestProperty("Accept", "application/vnd.github.v3+json");
        conn.connect();
        InputStream in = conn.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        String remoteRaw = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        reader.close();
        return new JSONArray(remoteRaw);
    }

    @NotNull
    private List<GitHubRelease> getReleases() {
        ArrayList<GitHubRelease> releases = new ArrayList<GitHubRelease>();
        JSONArray remoteVersions = this.array;
        for (int i = 0; i < remoteVersions.length(); ++i) {
            GitHubRelease temp = new GitHubRelease(remoteVersions.getJSONObject(i));
            releases.add(temp);
        }
        return releases;
    }

    public String getRepoURL() {
        return this.repoURL;
    }

    public void refreshReleases() throws IOException {
        this.array = this.readGitHubAPI(this.repositoryName, this.organizationName);
        this.releases = this.getReleases();
    }
}

