/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.java.ao.ActiveObjectsConfigurationException;
import net.java.ao.AnnotationDelegate;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.ManyToMany;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.Polymorphic;
import net.java.ao.RawEntity;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Default;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NameConverters;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.Unique;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.SQLAction;
import net.java.ao.schema.ddl.SchemaReader;
import net.java.ao.types.TypeInfo;
import net.java.ao.types.TypeManager;
import net.java.ao.types.TypeQualifiers;
import net.java.ao.util.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerator.class);
    private static final Set<Integer> AUTO_INCREMENT_LEGAL_TYPES = ImmutableSet.of((Object)4, (Object)-5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(DatabaseProvider provider, SchemaConfiguration schemaConfiguration, NameConverters nameConverters, Class<? extends RawEntity<?>> ... classes) throws SQLException {
        Iterable<Iterable<SQLAction>> actionGroups = SchemaGenerator.generateImpl(provider, schemaConfiguration, nameConverters, classes);
        Connection conn = provider.getConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                HashSet<String> completedStatements = new HashSet<String>();
                for (Iterable<SQLAction> actionGroup : actionGroups) {
                    Iterables.addAll(completedStatements, provider.executeUpdatesForActions(stmt, actionGroup, completedStatements));
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    private static Iterable<Iterable<SQLAction>> generateImpl(final DatabaseProvider provider, SchemaConfiguration schemaConfiguration, final NameConverters nameConverters, Class<? extends RawEntity<?>> ... classes) throws SQLException {
        DDLTable[] parsedTables = SchemaGenerator.parseDDL(provider, nameConverters, classes);
        DDLTable[] readTables = SchemaReader.readSchema(provider, nameConverters, schemaConfiguration);
        Object[] actions = SchemaReader.sortTopologically(SchemaReader.diffSchema(provider.getTypeManager(), parsedTables, readTables, provider.isCaseSensitive()));
        return Iterables.transform((Iterable)ImmutableList.of((Object[])actions), (Function)new Function<DDLAction, Iterable<SQLAction>>(){

            public Iterable<SQLAction> apply(DDLAction from) {
                return provider.renderAction(nameConverters, from);
            }
        });
    }

    static DDLTable[] parseDDL(DatabaseProvider provider, NameConverters nameConverters, Class<? extends RawEntity<?>> ... classes) {
        HashMap deps = new HashMap();
        LinkedHashSet roots = new LinkedHashSet();
        for (Class<RawEntity<?>> clazz : classes) {
            try {
                SchemaGenerator.parseDependencies(nameConverters.getFieldNameConverter(), deps, roots, clazz);
            }
            catch (StackOverflowError e) {
                throw new RuntimeException("Circular dependency detected in or below " + clazz.getCanonicalName());
            }
        }
        ArrayList<DDLTable> parsedTables = new ArrayList<DDLTable>();
        while (!roots.isEmpty()) {
            Class[] rootsArray = roots.toArray(new Class[roots.size()]);
            roots.remove(rootsArray[0]);
            Class clazz = rootsArray[0];
            if (clazz.getAnnotation(Polymorphic.class) == null) {
                parsedTables.add(SchemaGenerator.parseInterface(provider, nameConverters.getTableNameConverter(), nameConverters.getFieldNameConverter(), clazz));
            }
            LinkedList<Class> linkedList = new LinkedList<Class>();
            for (Class depClass : deps.keySet()) {
                Set individualDeps = (Set)deps.get(depClass);
                individualDeps.remove(clazz);
                if (!individualDeps.isEmpty()) continue;
                roots.add(depClass);
                linkedList.add(depClass);
            }
            for (Class remove : linkedList) {
                deps.remove(remove);
            }
        }
        return parsedTables.toArray(new DDLTable[parsedTables.size()]);
    }

    private static void parseDependencies(FieldNameConverter fieldConverter, Map<Class<? extends RawEntity<?>>, Set<Class<? extends RawEntity<?>>>> deps, Set<Class<? extends RawEntity<?>>> roots, Class<? extends RawEntity<?>> clazz) {
        if (deps.containsKey(clazz)) {
            return;
        }
        LinkedHashSet individualDeps = new LinkedHashSet();
        for (Method method : clazz.getMethods()) {
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            SchemaGenerator.validateManyToManyAnnotation(method);
            SchemaGenerator.validateOneToOneAnnotation(method);
            SchemaGenerator.validateOneToManyAnnotation(method);
            if (fieldConverter.getName(method) == null || type == null || type.equals(clazz) || !RawEntity.class.isAssignableFrom(type)) continue;
            individualDeps.add(type);
            SchemaGenerator.parseDependencies(fieldConverter, deps, roots, type);
        }
        if (individualDeps.size() == 0) {
            roots.add(clazz);
        } else {
            deps.put(clazz, individualDeps);
        }
    }

    private static void validateManyToManyAnnotation(Method method) {
        ManyToMany manyToMany = method.getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            Class<RawEntity<?>> throughType = manyToMany.value();
            String reverse = manyToMany.reverse();
            if (reverse.length() == 0) {
                logger.warn(method + " does not have a value specified for the reverse element of its ManyToMany annotation. A value will be required by a future version of ActiveObjects.");
            } else {
                try {
                    throughType.getMethod(reverse, new Class[0]);
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalArgumentException(method + " has a ManyToMany annotation with an invalid reverse element value. It must be the name of the corresponding getter method on the joining entity.", exception);
                }
            }
            if (manyToMany.through().length() == 0) {
                logger.warn(method + " does not have a value specified for the through element of its ManyToMany annotation. A value will be required by a future version of ActiveObjects.");
            } else {
                try {
                    throughType.getMethod(manyToMany.through(), new Class[0]);
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalArgumentException(method + " has a ManyToMany annotation with an invalid through element value. It must be the name of the getter method on the joining entity that refers to the remote entities.", exception);
                }
            }
        }
    }

    private static void validateOneToManyAnnotation(Method method) {
        OneToMany oneToMany = method.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            String reverse = oneToMany.reverse();
            if (reverse.length() == 0) {
                logger.warn(method + " does not have a value specified for the reverse element of its OneToMany annotation. A value will be required by a future version of ActiveObjects.");
            } else {
                try {
                    method.getReturnType().getComponentType().getMethod(reverse, new Class[0]);
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalArgumentException(method + " has a OneToMany annotation with an invalid reverse element value. It must be the name of the corresponding getter method on the related entity.", exception);
                }
            }
        }
    }

    private static void validateOneToOneAnnotation(Method method) {
        OneToOne oneToOne = method.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            String reverse = oneToOne.reverse();
            if (reverse.length() == 0) {
                logger.warn(method + " does not have a value specified for the reverse element of its OneToOne annotation. A value will be required by a future version of ActiveObjects.");
            } else {
                try {
                    method.getReturnType().getMethod(reverse, new Class[0]);
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalArgumentException(method + " has OneToMany annotation with an invalid reverse element value. It be the name of the corresponding getter method on the related entity.", exception);
                }
            }
        }
    }

    private static DDLTable parseInterface(DatabaseProvider provider, TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        String sqlName = nameConverter.getName(clazz);
        DDLTable table = new DDLTable();
        table.setName(sqlName);
        table.setFields(SchemaGenerator.parseFields(provider, fieldConverter, clazz));
        table.setForeignKeys(SchemaGenerator.parseForeignKeys(nameConverter, fieldConverter, clazz));
        table.setIndexes(SchemaGenerator.parseIndexes(provider, nameConverter, fieldConverter, clazz));
        return table;
    }

    public static DDLField[] parseFields(DatabaseProvider provider, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        ArrayList<DDLField> fields = new ArrayList<DDLField>();
        LinkedList<String> attributes = new LinkedList<String>();
        for (Method method : Common.getValueFieldsMethods(clazz, fieldConverter)) {
            String attributeName = fieldConverter.getName(method);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (attributeName == null || type == null) continue;
            SchemaGenerator.checkIsSupportedType(method, type);
            if (attributes.contains(attributeName)) continue;
            attributes.add(attributeName);
            AnnotationDelegate annotations = Common.getAnnotationDelegate(fieldConverter, method);
            DDLField field = new DDLField();
            field.setName(attributeName);
            TypeManager typeManager = provider.getTypeManager();
            TypeInfo<?> sqlType = SchemaGenerator.getSQLTypeFromMethod(typeManager, type, method, annotations);
            field.setType(sqlType);
            field.setJdbcType(sqlType.getJdbcWriteType());
            field.setPrimaryKey(SchemaGenerator.isPrimaryKey(annotations, field));
            field.setNotNull(annotations.isAnnotationPresent(NotNull.class) || annotations.isAnnotationPresent(Unique.class) || annotations.isAnnotationPresent(PrimaryKey.class));
            field.setUnique(annotations.isAnnotationPresent(Unique.class));
            boolean isAutoIncrement = SchemaGenerator.isAutoIncrement(type, annotations, field.getType());
            field.setAutoIncrement(isAutoIncrement);
            if (!isAutoIncrement) {
                if (annotations.isAnnotationPresent(Default.class)) {
                    Object defaultValue = SchemaGenerator.convertStringDefaultValue(annotations.getAnnotation(Default.class).value(), sqlType, method);
                    if (type.isEnum() && (Integer)defaultValue > EnumUtils.size(type) - 1) {
                        throw new ActiveObjectsConfigurationException("There is no enum value of '" + type + "'for which the ordinal is " + defaultValue);
                    }
                    field.setDefaultValue(defaultValue);
                } else if (ImmutableSet.of(Short.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE).contains(type)) {
                    field.setDefaultValue(SchemaGenerator.convertStringDefaultValue("0", sqlType, method));
                }
            }
            if (field.isPrimaryKey()) {
                fields.add(0, field);
            } else {
                fields.add(field);
            }
            if (!RawEntity.class.isAssignableFrom(type) || type.getAnnotation(Polymorphic.class) == null) continue;
            field.setDefaultValue(null);
            attributeName = fieldConverter.getPolyTypeName(method);
            field = new DDLField();
            field.setName(attributeName);
            field.setType(typeManager.getType(String.class, TypeQualifiers.qualifiers().stringLength(127)));
            field.setJdbcType(12);
            if (annotations.getAnnotation(NotNull.class) != null) {
                field.setNotNull(true);
            }
            fields.add(field);
        }
        return fields.toArray(new DDLField[fields.size()]);
    }

    private static void checkIsSupportedType(Method method, Class<?> type) {
        if (type.equals(Date.class)) {
            throw new ActiveObjectsConfigurationException(Date.class.getName() + " is not supported! Please use " + java.util.Date.class.getName() + " instead.").forMethod(method);
        }
    }

    private static boolean isPrimaryKey(AnnotationDelegate annotations, DDLField field) {
        boolean isPrimaryKey = annotations.isAnnotationPresent(PrimaryKey.class);
        if (isPrimaryKey && !field.getType().isAllowedAsPrimaryKey()) {
            throw new ActiveObjectsConfigurationException(PrimaryKey.class.getName() + " is not supported for type: " + field.getType());
        }
        return isPrimaryKey;
    }

    private static boolean isAutoIncrement(Class<?> type, AnnotationDelegate annotations, TypeInfo<?> dbType) {
        boolean isAutoIncrement = annotations.isAnnotationPresent(AutoIncrement.class);
        if (isAutoIncrement && (!AUTO_INCREMENT_LEGAL_TYPES.contains(dbType.getJdbcWriteType()) || type.isEnum())) {
            throw new ActiveObjectsConfigurationException(AutoIncrement.class.getName() + " is not supported for type: " + dbType);
        }
        return isAutoIncrement;
    }

    private static TypeInfo<?> getSQLTypeFromMethod(TypeManager typeManager, Class<?> type, Method method, AnnotationDelegate annotations) {
        TypeQualifiers qualifiers = TypeQualifiers.qualifiers();
        StringLength lengthAnno = annotations.getAnnotation(StringLength.class);
        if (lengthAnno != null) {
            int length = lengthAnno.value();
            if (length > 767) {
                throw new ActiveObjectsConfigurationException("@StringLength must be <= 767 or UNLIMITED").forMethod(method);
            }
            try {
                qualifiers = qualifiers.stringLength(length);
            }
            catch (ActiveObjectsConfigurationException e) {
                throw new ActiveObjectsConfigurationException(e.getMessage()).forMethod(method);
            }
        }
        return typeManager.getType(type, qualifiers);
    }

    private static DDLForeignKey[] parseForeignKeys(TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        LinkedHashSet<DDLForeignKey> back = new LinkedHashSet<DDLForeignKey>();
        for (Method method : clazz.getMethods()) {
            String attributeName = fieldConverter.getName(method);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (type == null || attributeName == null || !RawEntity.class.isAssignableFrom(type) || type.getAnnotation(Polymorphic.class) != null) continue;
            DDLForeignKey key = new DDLForeignKey();
            key.setField(attributeName);
            key.setTable(nameConverter.getName(type));
            key.setForeignField(Common.getPrimaryKeyField(type, fieldConverter));
            key.setDomesticTable(nameConverter.getName(clazz));
            back.add(key);
        }
        return back.toArray(new DDLForeignKey[back.size()]);
    }

    private static DDLIndex[] parseIndexes(DatabaseProvider provider, TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        LinkedHashSet<DDLIndex> back = new LinkedHashSet<DDLIndex>();
        String tableName = nameConverter.getName(clazz);
        for (Method method : clazz.getMethods()) {
            String attributeName = fieldConverter.getName(method);
            AnnotationDelegate annotations = Common.getAnnotationDelegate(fieldConverter, method);
            if (!Common.isAccessor(method) && !Common.isMutator(method)) continue;
            Indexed indexedAnno = annotations.getAnnotation(Indexed.class);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (indexedAnno == null && (type == null || !RawEntity.class.isAssignableFrom(type))) continue;
            DDLIndex index = new DDLIndex();
            index.setField(attributeName);
            index.setTable(tableName);
            index.setType(SchemaGenerator.getSQLTypeFromMethod(provider.getTypeManager(), type, method, annotations));
            back.add(index);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            if (genericDeclaration.equals(RawEntity.class) || ((Class)genericDeclaration).isAnnotationPresent(Polymorphic.class)) continue;
            back.addAll(Arrays.asList(SchemaGenerator.parseIndexes(provider, nameConverter, fieldConverter, genericDeclaration)));
        }
        return back.toArray(new DDLIndex[back.size()]);
    }

    private static Object convertStringDefaultValue(String value, TypeInfo<?> type, Method method) {
        if (value == null) {
            return null;
        }
        if (!type.getSchemaProperties().isDefaultValueAllowed()) {
            throw new ActiveObjectsConfigurationException("Default value is not allowed for database type " + type.getSchemaProperties().getSqlTypeName());
        }
        try {
            Object ret = type.getLogicalType().parseDefault(value);
            if (ret == null) {
                throw new ActiveObjectsConfigurationException("Default value cannot be empty").forMethod(method);
            }
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new ActiveObjectsConfigurationException(e.getMessage());
        }
    }
}

