/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.cache.RelationsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RAMRelationsCache
implements RelationsCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<CacheKey, RawEntity<?>[]> cache = new HashMap<CacheKey, RawEntity<?>[]>();
    private final Map<Class<? extends RawEntity<?>>, Set<CacheKey>> typeMap = new HashMap();
    private final Map<MetaCacheKey, Set<CacheKey>> fieldMap = new HashMap<MetaCacheKey, Set<CacheKey>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
            this.typeMap.clear();
            this.fieldMap.clear();
            this.logger.debug("flush");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RawEntity<?> from, RawEntity<?>[] through, Class<? extends RawEntity<?>> throughType, RawEntity<?>[] to, Class<? extends RawEntity<?>> toType, String[] fields) {
        CacheKey key = new CacheKey(from, toType, throughType, fields);
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, to);
            Set<CacheKey> keys = this.typeMap.get(key.getThroughType());
            if (keys == null) {
                keys = new HashSet<CacheKey>();
                this.typeMap.put(key.getThroughType(), keys);
            }
            keys.add(key);
            for (String field : fields) {
                for (RawEntity<?> entity : through) {
                    MetaCacheKey metaKey = new MetaCacheKey(entity, field);
                    keys = this.fieldMap.get(metaKey);
                    if (keys == null) {
                        keys = new HashSet<CacheKey>();
                        this.fieldMap.put(metaKey, keys);
                    }
                    keys.add(key);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("put ( {}, {}, {}, {}, {}, {} )", new Object[]{from, through, throughType, to, toType, Arrays.toString(fields)});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends RawEntity<K>, K> T[] get(RawEntity<?> from, Class<T> toType, Class<? extends RawEntity<?>> throughType, String[] fields) {
        this.lock.readLock().lock();
        try {
            Object[] ts = this.cache.get(new CacheKey(from, toType, throughType, fields));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("get ( {}, {}, {}, {} ) : {}", new Object[]{from, toType, throughType, Arrays.toString(fields), Arrays.toString(ts)});
            }
            Object[] objectArray = ts;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Class<? extends RawEntity<?>> ... types) {
        this.lock.writeLock().lock();
        try {
            for (Class<RawEntity<?>> clazz : types) {
                Set<CacheKey> keys = this.typeMap.get(clazz);
                if (keys == null) continue;
                for (CacheKey key : keys) {
                    this.cache.remove(key);
                }
                this.typeMap.remove(clazz);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove ( {} )", (Object)Arrays.toString(types));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RawEntity<?> entity, String[] fields) {
        this.lock.writeLock().lock();
        try {
            for (String field : fields) {
                Set<CacheKey> keys = this.fieldMap.get(new MetaCacheKey(entity, field));
                if (keys == null) continue;
                for (CacheKey key : keys) {
                    this.cache.remove(key);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove ( {}, {} )", entity, (Object)Arrays.toString(fields));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static final class MetaCacheKey {
        private RawEntity<?> entity;
        private String field;

        public MetaCacheKey(RawEntity<?> entity, String field) {
            this.entity = entity;
            this.setField(field);
        }

        public RawEntity<?> getEntity() {
            return this.entity;
        }

        public void setEntity(RawEntity<?> entity) {
            this.entity = entity;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String toString() {
            return this.entity.toString() + "; " + this.field;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MetaCacheKey) {
                MetaCacheKey key = (MetaCacheKey)obj;
                if (key.getEntity() != null && !key.getEntity().equals(this.entity)) {
                    return false;
                }
                return key.getField() == null || key.getField().equals(this.field);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.entity != null) {
                hashCode += this.entity.hashCode();
            }
            if (this.field != null) {
                hashCode += this.field.hashCode();
            }
            return hashCode %= 65536;
        }
    }

    private static final class CacheKey {
        private RawEntity<?> from;
        private Class<? extends RawEntity<?>> toType;
        private Class<? extends RawEntity<?>> throughType;
        private String[] fields;

        public CacheKey(RawEntity<?> from, Class<? extends RawEntity<?>> toType, Class<? extends RawEntity<?>> throughType, String[] fields) {
            this.from = from;
            this.toType = toType;
            this.throughType = throughType;
            this.setFields(fields);
        }

        public RawEntity<?> getFrom() {
            return this.from;
        }

        public void setFrom(RawEntity<?> from) {
            this.from = from;
        }

        public Class<? extends RawEntity<?>> getToType() {
            return this.toType;
        }

        public void setToType(Class<? extends RawEntity<?>> toType) {
            this.toType = toType;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            Arrays.sort(fields);
            this.fields = fields;
        }

        public Class<? extends RawEntity<?>> getThroughType() {
            return this.throughType;
        }

        public void setThroughType(Class<? extends RawEntity<?>> throughType) {
            this.throughType = throughType;
        }

        public String toString() {
            return '(' + this.from.toString() + "; to=" + this.toType.getName() + "; through=" + this.throughType.getName() + "; " + Arrays.toString(this.fields) + ')';
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey key = (CacheKey)obj;
                if (key.getFrom() != null && !key.getFrom().equals(this.from)) {
                    return false;
                }
                if (key.getToType() != null && !key.getToType().getName().equals(this.toType.getName())) {
                    return false;
                }
                if (key.getThroughType() != null && !key.getThroughType().getName().equals(this.throughType.getName())) {
                    return false;
                }
                return key.getFields() == null || Arrays.equals(key.getFields(), this.fields);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.from != null) {
                hashCode += this.from.hashCode();
            }
            if (this.toType != null) {
                hashCode += this.toType.getName().hashCode();
            }
            if (this.throughType != null) {
                hashCode += this.throughType.getName().hashCode();
            }
            if (this.fields != null) {
                for (String field : this.fields) {
                    hashCode += field.hashCode();
                }
            }
            return hashCode %= 2048;
        }
    }
}

