/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.Common;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

class BlobType
extends DatabaseType<Object> {
    public BlobType() {
        super(2004, -1, byte[].class, InputStream.class);
    }

    @Override
    public boolean shouldCache(Class<?> type) {
        if (Common.typeInstanceOf(type, InputStream.class)) {
            return false;
        }
        return super.shouldCache(type);
    }

    @Override
    public Object pullFromDatabase(EntityManager manager, ResultSet res, Class<?> type, String field) throws SQLException {
        return manager.getProvider().handleBlob(res, type, field);
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, Object value) throws SQLException {
        InputStream is = null;
        if (value instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])value);
        } else if (value instanceof InputStream) {
            is = (InputStream)value;
        } else {
            throw new IllegalArgumentException("BLOB value must be of type byte[] or InputStream");
        }
        boolean handled = false;
        try {
            Method m = stmt.getClass().getMethod("setBinaryStream", Integer.TYPE, InputStream.class);
            m.invoke((Object)stmt, index, is);
            handled = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!handled) {
            try {
                stmt.setBinaryStream(index, is, is.available());
            }
            catch (IOException e) {
                SQLException e2 = new SQLException(e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
    }

    @Override
    public Object defaultParseValue(String value) {
        if (value.equalsIgnoreCase("null")) {
            return null;
        }
        throw new IllegalArgumentException("Cannot assign a String representation to a BLOB");
    }

    @Override
    public String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("Cannot assign a String representation to a BLOB");
    }

    @Override
    public String getDefaultName() {
        return "BLOB";
    }
}

