/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.cache.RelationsCache;

final class ConcurrentRelationsCache
implements RelationsCache {
    private final RelationsCache cache;
    private final ReadWriteLock lock;

    ConcurrentRelationsCache(RelationsCache cache) {
        this.cache = (RelationsCache)Preconditions.checkNotNull((Object)cache);
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public <T extends RawEntity<K>, K> T[] get(final RawEntity<?> from, final Class<T> toType, final Class<? extends RawEntity<?>> throughType, final String[] fields, final String where) {
        return (RawEntity[])ConcurrentRelationsCache.withLock(this.lock.readLock(), new Callable<T[]>(){

            @Override
            public T[] call() {
                return ConcurrentRelationsCache.this.cache.get(from, toType, throughType, fields, where);
            }
        });
    }

    @Override
    public void put(final RawEntity<?> from, final RawEntity<?>[] through, final Class<? extends RawEntity<?>> throughType, final RawEntity<?>[] to, final Class<? extends RawEntity<?>> toType, final String[] fields, final String where) {
        ConcurrentRelationsCache.withLock(this.lock.writeLock(), new Callable<Void>(){

            @Override
            public Void call() {
                ConcurrentRelationsCache.this.cache.put(from, through, throughType, to, toType, fields, where);
                return null;
            }
        });
    }

    @Override
    public void remove(final Class<? extends RawEntity<?>> ... types) {
        ConcurrentRelationsCache.withLock(this.lock.writeLock(), new Callable<Void>(){

            @Override
            public Void call() {
                ConcurrentRelationsCache.this.cache.remove(types);
                return null;
            }
        });
    }

    @Override
    public void remove(final RawEntity<?> entity, final String[] fields) {
        ConcurrentRelationsCache.withLock(this.lock.writeLock(), new Callable<Void>(){

            @Override
            public Void call() {
                ConcurrentRelationsCache.this.cache.remove(entity, fields);
                return null;
            }
        });
    }

    @Override
    public void flush() {
        ConcurrentRelationsCache.withLock(this.lock.writeLock(), new Callable<Void>(){

            @Override
            public Void call() {
                ConcurrentRelationsCache.this.cache.flush();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withLock(Lock l, Callable<T> callable) {
        l.lock();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            l.unlock();
        }
    }

    private static interface Callable<T> {
        public T call();
    }
}

