/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.Arrays;
import net.java.ao.RawEntity;
import net.java.ao.cache.ConcurrentRelationsCache;
import net.java.ao.cache.MemoryRelationsCache;
import net.java.ao.cache.RelationsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RAMRelationsCache
implements RelationsCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RelationsCache cache = new ConcurrentRelationsCache(new MemoryRelationsCache());

    @Override
    public <T extends RawEntity<K>, K> T[] get(RawEntity<?> from, Class<T> toType, Class<? extends RawEntity<?>> throughType, String[] fields, String where) {
        Object[] ts = this.cache.get(from, toType, throughType, fields, where);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get ( {}, {}, {}, {} ) : {}", new Object[]{from, toType, throughType, Arrays.toString(fields), Arrays.toString(ts)});
        }
        return ts;
    }

    @Override
    public void put(RawEntity<?> from, RawEntity<?>[] through, Class<? extends RawEntity<?>> throughType, RawEntity<?>[] to, Class<? extends RawEntity<?>> toType, String[] fields, String where) {
        this.cache.put(from, through, throughType, to, toType, fields, where);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put ( {}, {}, {}, {}, {}, {}, {} )", new Object[]{from, Arrays.toString(through), throughType, Arrays.toString(to), toType, Arrays.toString(fields), where});
        }
    }

    @Override
    public void remove(Class<? extends RawEntity<?>> ... types) {
        this.cache.remove(types);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove ( {} )", (Object)Arrays.toString(types));
        }
    }

    @Override
    public void remove(RawEntity<?> entity, String[] fields) {
        this.cache.remove(entity, fields);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remove ( {}, {} )", entity, (Object)Arrays.toString(fields));
        }
    }

    @Override
    public void flush() {
        this.cache.flush();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("flush ()");
        }
    }
}

