/*
 * Decompiled with CFR 0.152.
 */
package net.java.hulp.i18n.buildtools;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18NTask
extends Task {
    private File classesDir;
    private File targetBundle;
    private boolean strict = true;
    private String prefix;
    private String prefixU;
    private String pattern = "([A-Z]\\d\\d\\d)(: )(.*)";
    private Pattern splitter;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int TAG_NOTHING = -1;
    public static final int TAG_UTF8 = 1;
    public static final int TAG_INTEGER = 3;
    public static final int TAG_FLOAT = 4;
    public static final int TAG_LONG = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_CLASS = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_FIELDREF = 9;
    public static final int TAG_METHODREF = 10;
    public static final int TAG_INTERFACEREF = 11;
    public static final int TAG_NAMETYPE = 12;
    private static String[] mArchiveExtensions = new String[]{".jar", ".zip", ".nbm", ".war", ".ear", ".rar", ".sar"};

    public void execute() {
        if (this.classesDir == null) {
            throw new BuildException("Directory must be specified");
        }
        if (this.targetBundle == null) {
            throw new BuildException("File must be specified");
        }
        this.splitter = Pattern.compile(this.pattern, 32);
        this.extract(this.classesDir.getAbsolutePath(), this.targetBundle.getAbsolutePath());
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(I18NTask.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(I18NTask.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(I18NTask.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(I18NTask.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public void extract(String dir, String propertiesPath) {
        try {
            String effectiveprefix;
            boolean error = false;
            boolean couldBeImproved = false;
            String string = effectiveprefix = this.prefixU != null ? this.prefixU.toUpperCase() : this.prefix;
            if (effectiveprefix == null) {
                effectiveprefix = "";
            }
            ArrayList<TextEntry> list = new ArrayList<TextEntry>();
            this.readDir(list, new File(dir).getAbsolutePath(), dir);
            StringWriter outbuf = new StringWriter();
            PrintWriter out = new PrintWriter(outbuf);
            out.println("# DO NOT EDIT");
            out.println("# THIS FILE IS GENERATED AUTOMATICALLY FROM JAVA SOURCES/CLASSES");
            out.println();
            TextEntry[] entries = list.toArray(new TextEntry[list.size()]);
            TreeSet<TextEntry> sortedByText = new TreeSet<TextEntry>(new Comparator<TextEntry>(){

                @Override
                public int compare(TextEntry lhs, TextEntry rhs) {
                    return lhs.getText().compareTo(rhs.getText());
                }
            });
            sortedByText.addAll(Arrays.asList(entries));
            HashMap byId = new HashMap();
            HashMap byContent = new HashMap();
            for (int i = 0; i < entries.length; ++i) {
                TextEntry textEntry = entries[i];
                if (byId.get(textEntry.getID()) == null) {
                    byId.put(textEntry.getID(), new ArrayList());
                }
                ((List)byId.get(textEntry.getID())).add(textEntry);
                if (byContent.get(textEntry.getContent()) == null) {
                    byContent.put(textEntry.getContent(), new ArrayList());
                }
                ((List)byContent.get(textEntry.getContent())).add(textEntry);
            }
            for (TextEntry textEntry : sortedByText) {
                List sources = (List)byId.get(textEntry.getID());
                for (TextEntry e2 : sources) {
                    out.println("# " + e2.getClassname());
                    if (e2.getContent().equals(textEntry.getContent())) continue;
                    error = true;
                    System.err.println();
                    System.err.println("DIFFERENT TEXTS, SAME IDS: ");
                    System.err.println(textEntry.getClassname());
                    System.err.println(textEntry.getText());
                    System.err.println(e2.getClassname());
                    System.err.println(e2.getText());
                }
                out.println(effectiveprefix + textEntry.getID() + " = " + this.saveConvert(textEntry.getContent(), false));
                out.println();
            }
            for (Map.Entry entry : byContent.entrySet()) {
                List dups = (List)entry.getValue();
                TreeSet ids = new TreeSet(new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        TextEntry lhs = (TextEntry)arg0;
                        TextEntry rhs = (TextEntry)arg1;
                        return lhs.getID().compareTo(rhs.getID());
                    }
                });
                ids.addAll(dups);
                if (ids.size() <= 1) continue;
                System.err.println();
                System.err.println("SAME TEXTS, DIFFERENT IDS");
                Iterator iterator = dups.iterator();
                while (iterator.hasNext()) {
                    couldBeImproved = true;
                    TextEntry dup = (TextEntry)iterator.next();
                    System.err.println(dup.getClassname());
                    System.err.println(dup.getText());
                }
            }
            out.close();
            out = null;
            String old = I18NTask.read(propertiesPath);
            String string2 = outbuf.getBuffer().toString();
            if (!string2.equals(old)) {
                System.out.println("Updating " + propertiesPath);
                I18NTask.write(propertiesPath, string2);
            } else {
                System.out.println("Up to date: " + propertiesPath);
            }
            if (error) {
                throw new BuildException("Duplicate ids but different texts; see console output for details");
            }
            if (couldBeImproved && this.strict) {
                throw new BuildException("Duplicate texts but different ids; see console output for details");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void safeClose(InputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeClose(Writer s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(String path) throws Exception {
        String string;
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        int len = (int)f.length();
        byte[] buf = new byte[len];
        FileInputStream inp = null;
        try {
            inp = new FileInputStream(path);
            int nbread = inp.read(buf);
            if (nbread != len) {
                throw new IOException(nbread + " read, " + len + " length");
            }
            string = new String(buf);
        }
        catch (Throwable throwable) {
            I18NTask.safeClose(inp);
            throw throwable;
        }
        I18NTask.safeClose(inp);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(String path, String contents) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            out.write(contents.getBytes("8859_1"));
        }
        catch (Throwable throwable) {
            I18NTask.safeClose(out);
            throw throwable;
        }
        I18NTask.safeClose(out);
    }

    private static boolean isArchive(ZipEntry entry) {
        for (int i = 0; i < mArchiveExtensions.length; ++i) {
            if (!entry.getName().endsWith(mArchiveExtensions[i])) continue;
            return true;
        }
        return false;
    }

    private void readDir(List<TextEntry> list, String root, String currentPath) throws Exception {
        File[] entries = new File(currentPath).listFiles();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].isDirectory()) {
                this.readDir(list, root, entries[i].getAbsolutePath());
                continue;
            }
            if (!entries[i].getName().endsWith(".class")) continue;
            FileInputStream inp = null;
            try {
                inp = new FileInputStream(entries[i]);
                List<String> strings = I18NTask.readStrings(inp);
                for (String s : strings) {
                    Matcher m = this.splitter.matcher(s);
                    if (!m.matches()) continue;
                    list.add(new TextEntry(currentPath, entries[i].getAbsolutePath().substring(root.length() + 1), s));
                }
            }
            catch (Exception ex) {
                try {
                    throw new Exception("Inspection failed of " + entries[i].getName() + ": " + ex, ex);
                }
                catch (Throwable throwable) {
                    I18NTask.safeClose(inp);
                    throw throwable;
                }
            }
            I18NTask.safeClose(inp);
            continue;
        }
    }

    public void readJar(List<TextEntry> list, InputStream jar, String currentPath) throws Exception {
        ZipEntry entry;
        ZipInputStream inp = new ZipInputStream(jar);
        while ((entry = inp.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            if (I18NTask.isArchive(entry)) {
                String path = currentPath + entry.getName() + "#/";
                this.readJar(list, inp, path);
                continue;
            }
            if (!entry.getName().endsWith(".class")) continue;
            try {
                List<String> strings = I18NTask.readStrings(inp);
                for (String s : strings) {
                    Matcher m = this.splitter.matcher(s);
                    if (!m.matches()) continue;
                    list.add(new TextEntry(currentPath, entry.getName(), s));
                }
            }
            catch (Exception ex) {
                throw new Exception("Inspection failed of " + entry.getName() + ": " + ex, ex);
            }
        }
    }

    public static List<String> readStrings(InputStream s) throws Exception {
        DataInputStream inp = new DataInputStream(s);
        int magic = inp.readInt();
        if (magic != -889275714) {
            throw new Exception("Invalid Magic Number");
        }
        inp.readShort();
        inp.readShort();
        int nEntries = inp.readShort();
        ArrayList<String> strings = new ArrayList<String>();
        block13: for (int i = 1; i < nEntries; ++i) {
            byte tagByte = inp.readByte();
            switch (tagByte) {
                case 1: {
                    String utfString = inp.readUTF();
                    strings.add(utfString);
                    continue block13;
                }
                case 3: {
                    inp.readInt();
                    continue block13;
                }
                case 4: {
                    inp.readFloat();
                    continue block13;
                }
                case 5: {
                    inp.readLong();
                    ++i;
                    continue block13;
                }
                case 6: {
                    inp.readDouble();
                    ++i;
                    continue block13;
                }
                case 7: {
                    inp.readShort();
                    continue block13;
                }
                case 8: {
                    inp.readShort();
                    continue block13;
                }
                case 9: {
                    inp.readShort();
                    inp.readShort();
                    continue block13;
                }
                case 10: {
                    inp.readShort();
                    inp.readShort();
                    continue block13;
                }
                case 11: {
                    inp.readShort();
                    inp.readShort();
                    continue block13;
                }
                case 12: {
                    inp.readShort();
                    inp.readShort();
                    continue block13;
                }
                default: {
                    throw new Exception("Unknown tagbyte " + tagByte + " in constant pool (entry " + i + " out of " + nEntries + ")");
                }
            }
        }
        return strings;
    }

    public File getDir() {
        return this.classesDir;
    }

    public void setDir(File dir) {
        this.classesDir = dir;
    }

    public File getFile() {
        return this.targetBundle;
    }

    public void setFile(File file) {
        this.targetBundle = file;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String getPrefixU() {
        return this.prefixU;
    }

    public void setPrefixU(String prefixU) {
        this.prefixU = prefixU;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private class TextEntry {
        private String jarURL;
        private String classname;
        private String text;
        private String id;
        private String content;

        public TextEntry(String jarurl, String classname, String text) {
            this.jarURL = jarurl;
            this.classname = classname;
            this.text = text;
        }

        public String getClassname() {
            return this.classname;
        }

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public String getJarURL() {
            return this.jarURL;
        }

        public String getText() {
            return this.text;
        }

        public String getID() {
            if (this.id == null) {
                Matcher m = I18NTask.this.splitter.matcher(this.text);
                if (!m.matches()) {
                    throw new RuntimeException("String not match pattern: " + this.text);
                }
                this.id = m.group(1);
                this.content = m.group(3);
            }
            return this.id;
        }

        public String getContent() {
            if (this.content == null) {
                this.getID();
            }
            return this.content;
        }

        public boolean matches(String s) {
            Matcher m = I18NTask.this.splitter.matcher(s);
            return m.matches();
        }
    }
}

