/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.mcsp.model.McSpData;
import net.raphimc.noteblocklib.format.mcsp.model.McSpHeader;
import net.raphimc.noteblocklib.format.mcsp.model.McSpLayer;
import net.raphimc.noteblocklib.format.mcsp.model.McSpNote;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.model.SongView;

public class McSpSong
extends Song<McSpHeader, McSpData, McSpNote> {
    public McSpSong(String fileName, McSpHeader header, McSpData data) {
        super(SongFormat.MCSP, fileName, header, data);
    }

    @Override
    protected SongView<McSpNote> createView() {
        String title = ((McSpHeader)this.getHeader()).getTitle().isEmpty() ? (this.fileName == null ? "MCSP Song" : this.fileName) : ((McSpHeader)this.getHeader()).getTitle();
        TreeMap notes = new TreeMap();
        for (McSpLayer layer : ((McSpData)this.getData()).getLayers()) {
            for (Map.Entry<Integer, McSpNote> note : layer.getNotesAtTick().entrySet()) {
                notes.computeIfAbsent(note.getKey(), k -> new ArrayList()).add(note.getValue());
            }
        }
        return new SongView<McSpNote>(title, ((McSpHeader)this.getHeader()).getSpeed(), notes);
    }
}

